//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package batch

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// BatchReferencesCreateReader is a Reader for the BatchReferencesCreate structure.
type BatchReferencesCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *BatchReferencesCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewBatchReferencesCreateOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewBatchReferencesCreateBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewBatchReferencesCreateUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewBatchReferencesCreateForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 422:
		result := NewBatchReferencesCreateUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewBatchReferencesCreateInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewBatchReferencesCreateOK creates a BatchReferencesCreateOK with default headers values
func NewBatchReferencesCreateOK() *BatchReferencesCreateOK {
	return &BatchReferencesCreateOK{}
}

/*
BatchReferencesCreateOK describes a response with status code 200, with default header values.

Request Successful. Warning: A successful request does not guarantee that every batched reference was successfully created. Inspect the response body to see which references succeeded and which failed.
*/
type BatchReferencesCreateOK struct {
	Payload []*models.BatchReferenceResponse
}

// IsSuccess returns true when this batch references create o k response has a 2xx status code
func (o *BatchReferencesCreateOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this batch references create o k response has a 3xx status code
func (o *BatchReferencesCreateOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this batch references create o k response has a 4xx status code
func (o *BatchReferencesCreateOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this batch references create o k response has a 5xx status code
func (o *BatchReferencesCreateOK) IsServerError() bool {
	return false
}

// IsCode returns true when this batch references create o k response a status code equal to that given
func (o *BatchReferencesCreateOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the batch references create o k response
func (o *BatchReferencesCreateOK) Code() int {
	return 200
}

func (o *BatchReferencesCreateOK) Error() string {
	return fmt.Sprintf("[POST /batch/references][%d] batchReferencesCreateOK  %+v", 200, o.Payload)
}

func (o *BatchReferencesCreateOK) String() string {
	return fmt.Sprintf("[POST /batch/references][%d] batchReferencesCreateOK  %+v", 200, o.Payload)
}

func (o *BatchReferencesCreateOK) GetPayload() []*models.BatchReferenceResponse {
	return o.Payload
}

func (o *BatchReferencesCreateOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBatchReferencesCreateBadRequest creates a BatchReferencesCreateBadRequest with default headers values
func NewBatchReferencesCreateBadRequest() *BatchReferencesCreateBadRequest {
	return &BatchReferencesCreateBadRequest{}
}

/*
BatchReferencesCreateBadRequest describes a response with status code 400, with default header values.

Malformed request.
*/
type BatchReferencesCreateBadRequest struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this batch references create bad request response has a 2xx status code
func (o *BatchReferencesCreateBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this batch references create bad request response has a 3xx status code
func (o *BatchReferencesCreateBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this batch references create bad request response has a 4xx status code
func (o *BatchReferencesCreateBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this batch references create bad request response has a 5xx status code
func (o *BatchReferencesCreateBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this batch references create bad request response a status code equal to that given
func (o *BatchReferencesCreateBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the batch references create bad request response
func (o *BatchReferencesCreateBadRequest) Code() int {
	return 400
}

func (o *BatchReferencesCreateBadRequest) Error() string {
	return fmt.Sprintf("[POST /batch/references][%d] batchReferencesCreateBadRequest  %+v", 400, o.Payload)
}

func (o *BatchReferencesCreateBadRequest) String() string {
	return fmt.Sprintf("[POST /batch/references][%d] batchReferencesCreateBadRequest  %+v", 400, o.Payload)
}

func (o *BatchReferencesCreateBadRequest) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *BatchReferencesCreateBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBatchReferencesCreateUnauthorized creates a BatchReferencesCreateUnauthorized with default headers values
func NewBatchReferencesCreateUnauthorized() *BatchReferencesCreateUnauthorized {
	return &BatchReferencesCreateUnauthorized{}
}

/*
BatchReferencesCreateUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type BatchReferencesCreateUnauthorized struct {
}

// IsSuccess returns true when this batch references create unauthorized response has a 2xx status code
func (o *BatchReferencesCreateUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this batch references create unauthorized response has a 3xx status code
func (o *BatchReferencesCreateUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this batch references create unauthorized response has a 4xx status code
func (o *BatchReferencesCreateUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this batch references create unauthorized response has a 5xx status code
func (o *BatchReferencesCreateUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this batch references create unauthorized response a status code equal to that given
func (o *BatchReferencesCreateUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the batch references create unauthorized response
func (o *BatchReferencesCreateUnauthorized) Code() int {
	return 401
}

func (o *BatchReferencesCreateUnauthorized) Error() string {
	return fmt.Sprintf("[POST /batch/references][%d] batchReferencesCreateUnauthorized ", 401)
}

func (o *BatchReferencesCreateUnauthorized) String() string {
	return fmt.Sprintf("[POST /batch/references][%d] batchReferencesCreateUnauthorized ", 401)
}

func (o *BatchReferencesCreateUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewBatchReferencesCreateForbidden creates a BatchReferencesCreateForbidden with default headers values
func NewBatchReferencesCreateForbidden() *BatchReferencesCreateForbidden {
	return &BatchReferencesCreateForbidden{}
}

/*
BatchReferencesCreateForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type BatchReferencesCreateForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this batch references create forbidden response has a 2xx status code
func (o *BatchReferencesCreateForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this batch references create forbidden response has a 3xx status code
func (o *BatchReferencesCreateForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this batch references create forbidden response has a 4xx status code
func (o *BatchReferencesCreateForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this batch references create forbidden response has a 5xx status code
func (o *BatchReferencesCreateForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this batch references create forbidden response a status code equal to that given
func (o *BatchReferencesCreateForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the batch references create forbidden response
func (o *BatchReferencesCreateForbidden) Code() int {
	return 403
}

func (o *BatchReferencesCreateForbidden) Error() string {
	return fmt.Sprintf("[POST /batch/references][%d] batchReferencesCreateForbidden  %+v", 403, o.Payload)
}

func (o *BatchReferencesCreateForbidden) String() string {
	return fmt.Sprintf("[POST /batch/references][%d] batchReferencesCreateForbidden  %+v", 403, o.Payload)
}

func (o *BatchReferencesCreateForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *BatchReferencesCreateForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBatchReferencesCreateUnprocessableEntity creates a BatchReferencesCreateUnprocessableEntity with default headers values
func NewBatchReferencesCreateUnprocessableEntity() *BatchReferencesCreateUnprocessableEntity {
	return &BatchReferencesCreateUnprocessableEntity{}
}

/*
BatchReferencesCreateUnprocessableEntity describes a response with status code 422, with default header values.

The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request. Ensure the collection exists and the object properties are valid.
*/
type BatchReferencesCreateUnprocessableEntity struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this batch references create unprocessable entity response has a 2xx status code
func (o *BatchReferencesCreateUnprocessableEntity) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this batch references create unprocessable entity response has a 3xx status code
func (o *BatchReferencesCreateUnprocessableEntity) IsRedirect() bool {
	return false
}

// IsClientError returns true when this batch references create unprocessable entity response has a 4xx status code
func (o *BatchReferencesCreateUnprocessableEntity) IsClientError() bool {
	return true
}

// IsServerError returns true when this batch references create unprocessable entity response has a 5xx status code
func (o *BatchReferencesCreateUnprocessableEntity) IsServerError() bool {
	return false
}

// IsCode returns true when this batch references create unprocessable entity response a status code equal to that given
func (o *BatchReferencesCreateUnprocessableEntity) IsCode(code int) bool {
	return code == 422
}

// Code gets the status code for the batch references create unprocessable entity response
func (o *BatchReferencesCreateUnprocessableEntity) Code() int {
	return 422
}

func (o *BatchReferencesCreateUnprocessableEntity) Error() string {
	return fmt.Sprintf("[POST /batch/references][%d] batchReferencesCreateUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *BatchReferencesCreateUnprocessableEntity) String() string {
	return fmt.Sprintf("[POST /batch/references][%d] batchReferencesCreateUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *BatchReferencesCreateUnprocessableEntity) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *BatchReferencesCreateUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBatchReferencesCreateInternalServerError creates a BatchReferencesCreateInternalServerError with default headers values
func NewBatchReferencesCreateInternalServerError() *BatchReferencesCreateInternalServerError {
	return &BatchReferencesCreateInternalServerError{}
}

/*
BatchReferencesCreateInternalServerError describes a response with status code 500, with default header values.

An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.
*/
type BatchReferencesCreateInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this batch references create internal server error response has a 2xx status code
func (o *BatchReferencesCreateInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this batch references create internal server error response has a 3xx status code
func (o *BatchReferencesCreateInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this batch references create internal server error response has a 4xx status code
func (o *BatchReferencesCreateInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this batch references create internal server error response has a 5xx status code
func (o *BatchReferencesCreateInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this batch references create internal server error response a status code equal to that given
func (o *BatchReferencesCreateInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the batch references create internal server error response
func (o *BatchReferencesCreateInternalServerError) Code() int {
	return 500
}

func (o *BatchReferencesCreateInternalServerError) Error() string {
	return fmt.Sprintf("[POST /batch/references][%d] batchReferencesCreateInternalServerError  %+v", 500, o.Payload)
}

func (o *BatchReferencesCreateInternalServerError) String() string {
	return fmt.Sprintf("[POST /batch/references][%d] batchReferencesCreateInternalServerError  %+v", 500, o.Payload)
}

func (o *BatchReferencesCreateInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *BatchReferencesCreateInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
