//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package nodes

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewNodesGetParams creates a new NodesGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNodesGetParams() *NodesGetParams {
	return &NodesGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNodesGetParamsWithTimeout creates a new NodesGetParams object
// with the ability to set a timeout on a request.
func NewNodesGetParamsWithTimeout(timeout time.Duration) *NodesGetParams {
	return &NodesGetParams{
		timeout: timeout,
	}
}

// NewNodesGetParamsWithContext creates a new NodesGetParams object
// with the ability to set a context for a request.
func NewNodesGetParamsWithContext(ctx context.Context) *NodesGetParams {
	return &NodesGetParams{
		Context: ctx,
	}
}

// NewNodesGetParamsWithHTTPClient creates a new NodesGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewNodesGetParamsWithHTTPClient(client *http.Client) *NodesGetParams {
	return &NodesGetParams{
		HTTPClient: client,
	}
}

/*
NodesGetParams contains all the parameters to send to the API endpoint

	for the nodes get operation.

	Typically these are written to a http.Request.
*/
type NodesGetParams struct {

	/* Output.

	   Controls the verbosity of the output, possible values are: `minimal`, `verbose`. Defaults to `minimal`.

	   Default: "minimal"
	*/
	Output *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the nodes get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NodesGetParams) WithDefaults() *NodesGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the nodes get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NodesGetParams) SetDefaults() {
	var (
		outputDefault = string("minimal")
	)

	val := NodesGetParams{
		Output: &outputDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the nodes get params
func (o *NodesGetParams) WithTimeout(timeout time.Duration) *NodesGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the nodes get params
func (o *NodesGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the nodes get params
func (o *NodesGetParams) WithContext(ctx context.Context) *NodesGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the nodes get params
func (o *NodesGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the nodes get params
func (o *NodesGetParams) WithHTTPClient(client *http.Client) *NodesGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the nodes get params
func (o *NodesGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithOutput adds the output to the nodes get params
func (o *NodesGetParams) WithOutput(output *string) *NodesGetParams {
	o.SetOutput(output)
	return o
}

// SetOutput adds the output to the nodes get params
func (o *NodesGetParams) SetOutput(output *string) {
	o.Output = output
}

// WriteToRequest writes these params to a swagger request
func (o *NodesGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Output != nil {

		// query param output
		var qrOutput string

		if o.Output != nil {
			qrOutput = *o.Output
		}
		qOutput := qrOutput
		if qOutput != "" {

			if err := r.SetQueryParam("output", qOutput); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
