//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package objects

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// ObjectsClassPatchReader is a Reader for the ObjectsClassPatch structure.
type ObjectsClassPatchReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ObjectsClassPatchReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 204:
		result := NewObjectsClassPatchNoContent()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewObjectsClassPatchBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewObjectsClassPatchUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewObjectsClassPatchForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewObjectsClassPatchNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 422:
		result := NewObjectsClassPatchUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewObjectsClassPatchInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewObjectsClassPatchNoContent creates a ObjectsClassPatchNoContent with default headers values
func NewObjectsClassPatchNoContent() *ObjectsClassPatchNoContent {
	return &ObjectsClassPatchNoContent{}
}

/*
ObjectsClassPatchNoContent describes a response with status code 204, with default header values.

Object patched successfully.
*/
type ObjectsClassPatchNoContent struct {
}

// IsSuccess returns true when this objects class patch no content response has a 2xx status code
func (o *ObjectsClassPatchNoContent) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this objects class patch no content response has a 3xx status code
func (o *ObjectsClassPatchNoContent) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects class patch no content response has a 4xx status code
func (o *ObjectsClassPatchNoContent) IsClientError() bool {
	return false
}

// IsServerError returns true when this objects class patch no content response has a 5xx status code
func (o *ObjectsClassPatchNoContent) IsServerError() bool {
	return false
}

// IsCode returns true when this objects class patch no content response a status code equal to that given
func (o *ObjectsClassPatchNoContent) IsCode(code int) bool {
	return code == 204
}

// Code gets the status code for the objects class patch no content response
func (o *ObjectsClassPatchNoContent) Code() int {
	return 204
}

func (o *ObjectsClassPatchNoContent) Error() string {
	return fmt.Sprintf("[PATCH /objects/{className}/{id}][%d] objectsClassPatchNoContent ", 204)
}

func (o *ObjectsClassPatchNoContent) String() string {
	return fmt.Sprintf("[PATCH /objects/{className}/{id}][%d] objectsClassPatchNoContent ", 204)
}

func (o *ObjectsClassPatchNoContent) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewObjectsClassPatchBadRequest creates a ObjectsClassPatchBadRequest with default headers values
func NewObjectsClassPatchBadRequest() *ObjectsClassPatchBadRequest {
	return &ObjectsClassPatchBadRequest{}
}

/*
ObjectsClassPatchBadRequest describes a response with status code 400, with default header values.

Malformed patch request body.
*/
type ObjectsClassPatchBadRequest struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this objects class patch bad request response has a 2xx status code
func (o *ObjectsClassPatchBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects class patch bad request response has a 3xx status code
func (o *ObjectsClassPatchBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects class patch bad request response has a 4xx status code
func (o *ObjectsClassPatchBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this objects class patch bad request response has a 5xx status code
func (o *ObjectsClassPatchBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this objects class patch bad request response a status code equal to that given
func (o *ObjectsClassPatchBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the objects class patch bad request response
func (o *ObjectsClassPatchBadRequest) Code() int {
	return 400
}

func (o *ObjectsClassPatchBadRequest) Error() string {
	return fmt.Sprintf("[PATCH /objects/{className}/{id}][%d] objectsClassPatchBadRequest  %+v", 400, o.Payload)
}

func (o *ObjectsClassPatchBadRequest) String() string {
	return fmt.Sprintf("[PATCH /objects/{className}/{id}][%d] objectsClassPatchBadRequest  %+v", 400, o.Payload)
}

func (o *ObjectsClassPatchBadRequest) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ObjectsClassPatchBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewObjectsClassPatchUnauthorized creates a ObjectsClassPatchUnauthorized with default headers values
func NewObjectsClassPatchUnauthorized() *ObjectsClassPatchUnauthorized {
	return &ObjectsClassPatchUnauthorized{}
}

/*
ObjectsClassPatchUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type ObjectsClassPatchUnauthorized struct {
}

// IsSuccess returns true when this objects class patch unauthorized response has a 2xx status code
func (o *ObjectsClassPatchUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects class patch unauthorized response has a 3xx status code
func (o *ObjectsClassPatchUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects class patch unauthorized response has a 4xx status code
func (o *ObjectsClassPatchUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this objects class patch unauthorized response has a 5xx status code
func (o *ObjectsClassPatchUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this objects class patch unauthorized response a status code equal to that given
func (o *ObjectsClassPatchUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the objects class patch unauthorized response
func (o *ObjectsClassPatchUnauthorized) Code() int {
	return 401
}

func (o *ObjectsClassPatchUnauthorized) Error() string {
	return fmt.Sprintf("[PATCH /objects/{className}/{id}][%d] objectsClassPatchUnauthorized ", 401)
}

func (o *ObjectsClassPatchUnauthorized) String() string {
	return fmt.Sprintf("[PATCH /objects/{className}/{id}][%d] objectsClassPatchUnauthorized ", 401)
}

func (o *ObjectsClassPatchUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewObjectsClassPatchForbidden creates a ObjectsClassPatchForbidden with default headers values
func NewObjectsClassPatchForbidden() *ObjectsClassPatchForbidden {
	return &ObjectsClassPatchForbidden{}
}

/*
ObjectsClassPatchForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type ObjectsClassPatchForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this objects class patch forbidden response has a 2xx status code
func (o *ObjectsClassPatchForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects class patch forbidden response has a 3xx status code
func (o *ObjectsClassPatchForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects class patch forbidden response has a 4xx status code
func (o *ObjectsClassPatchForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this objects class patch forbidden response has a 5xx status code
func (o *ObjectsClassPatchForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this objects class patch forbidden response a status code equal to that given
func (o *ObjectsClassPatchForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the objects class patch forbidden response
func (o *ObjectsClassPatchForbidden) Code() int {
	return 403
}

func (o *ObjectsClassPatchForbidden) Error() string {
	return fmt.Sprintf("[PATCH /objects/{className}/{id}][%d] objectsClassPatchForbidden  %+v", 403, o.Payload)
}

func (o *ObjectsClassPatchForbidden) String() string {
	return fmt.Sprintf("[PATCH /objects/{className}/{id}][%d] objectsClassPatchForbidden  %+v", 403, o.Payload)
}

func (o *ObjectsClassPatchForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ObjectsClassPatchForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewObjectsClassPatchNotFound creates a ObjectsClassPatchNotFound with default headers values
func NewObjectsClassPatchNotFound() *ObjectsClassPatchNotFound {
	return &ObjectsClassPatchNotFound{}
}

/*
ObjectsClassPatchNotFound describes a response with status code 404, with default header values.

Object not found.
*/
type ObjectsClassPatchNotFound struct {
}

// IsSuccess returns true when this objects class patch not found response has a 2xx status code
func (o *ObjectsClassPatchNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects class patch not found response has a 3xx status code
func (o *ObjectsClassPatchNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects class patch not found response has a 4xx status code
func (o *ObjectsClassPatchNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this objects class patch not found response has a 5xx status code
func (o *ObjectsClassPatchNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this objects class patch not found response a status code equal to that given
func (o *ObjectsClassPatchNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the objects class patch not found response
func (o *ObjectsClassPatchNotFound) Code() int {
	return 404
}

func (o *ObjectsClassPatchNotFound) Error() string {
	return fmt.Sprintf("[PATCH /objects/{className}/{id}][%d] objectsClassPatchNotFound ", 404)
}

func (o *ObjectsClassPatchNotFound) String() string {
	return fmt.Sprintf("[PATCH /objects/{className}/{id}][%d] objectsClassPatchNotFound ", 404)
}

func (o *ObjectsClassPatchNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewObjectsClassPatchUnprocessableEntity creates a ObjectsClassPatchUnprocessableEntity with default headers values
func NewObjectsClassPatchUnprocessableEntity() *ObjectsClassPatchUnprocessableEntity {
	return &ObjectsClassPatchUnprocessableEntity{}
}

/*
ObjectsClassPatchUnprocessableEntity describes a response with status code 422, with default header values.

The patch object is valid JSON but is unprocessable for other reasons (e.g., invalid schema).
*/
type ObjectsClassPatchUnprocessableEntity struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this objects class patch unprocessable entity response has a 2xx status code
func (o *ObjectsClassPatchUnprocessableEntity) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects class patch unprocessable entity response has a 3xx status code
func (o *ObjectsClassPatchUnprocessableEntity) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects class patch unprocessable entity response has a 4xx status code
func (o *ObjectsClassPatchUnprocessableEntity) IsClientError() bool {
	return true
}

// IsServerError returns true when this objects class patch unprocessable entity response has a 5xx status code
func (o *ObjectsClassPatchUnprocessableEntity) IsServerError() bool {
	return false
}

// IsCode returns true when this objects class patch unprocessable entity response a status code equal to that given
func (o *ObjectsClassPatchUnprocessableEntity) IsCode(code int) bool {
	return code == 422
}

// Code gets the status code for the objects class patch unprocessable entity response
func (o *ObjectsClassPatchUnprocessableEntity) Code() int {
	return 422
}

func (o *ObjectsClassPatchUnprocessableEntity) Error() string {
	return fmt.Sprintf("[PATCH /objects/{className}/{id}][%d] objectsClassPatchUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *ObjectsClassPatchUnprocessableEntity) String() string {
	return fmt.Sprintf("[PATCH /objects/{className}/{id}][%d] objectsClassPatchUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *ObjectsClassPatchUnprocessableEntity) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ObjectsClassPatchUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewObjectsClassPatchInternalServerError creates a ObjectsClassPatchInternalServerError with default headers values
func NewObjectsClassPatchInternalServerError() *ObjectsClassPatchInternalServerError {
	return &ObjectsClassPatchInternalServerError{}
}

/*
ObjectsClassPatchInternalServerError describes a response with status code 500, with default header values.

An error occurred while trying to fulfill the request. Check the ErrorResponse for details.
*/
type ObjectsClassPatchInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this objects class patch internal server error response has a 2xx status code
func (o *ObjectsClassPatchInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects class patch internal server error response has a 3xx status code
func (o *ObjectsClassPatchInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects class patch internal server error response has a 4xx status code
func (o *ObjectsClassPatchInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this objects class patch internal server error response has a 5xx status code
func (o *ObjectsClassPatchInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this objects class patch internal server error response a status code equal to that given
func (o *ObjectsClassPatchInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the objects class patch internal server error response
func (o *ObjectsClassPatchInternalServerError) Code() int {
	return 500
}

func (o *ObjectsClassPatchInternalServerError) Error() string {
	return fmt.Sprintf("[PATCH /objects/{className}/{id}][%d] objectsClassPatchInternalServerError  %+v", 500, o.Payload)
}

func (o *ObjectsClassPatchInternalServerError) String() string {
	return fmt.Sprintf("[PATCH /objects/{className}/{id}][%d] objectsClassPatchInternalServerError  %+v", 500, o.Payload)
}

func (o *ObjectsClassPatchInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ObjectsClassPatchInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
