//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package objects

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// ObjectsClassReferencesDeleteReader is a Reader for the ObjectsClassReferencesDelete structure.
type ObjectsClassReferencesDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ObjectsClassReferencesDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 204:
		result := NewObjectsClassReferencesDeleteNoContent()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewObjectsClassReferencesDeleteBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewObjectsClassReferencesDeleteUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewObjectsClassReferencesDeleteForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewObjectsClassReferencesDeleteNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 422:
		result := NewObjectsClassReferencesDeleteUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewObjectsClassReferencesDeleteInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewObjectsClassReferencesDeleteNoContent creates a ObjectsClassReferencesDeleteNoContent with default headers values
func NewObjectsClassReferencesDeleteNoContent() *ObjectsClassReferencesDeleteNoContent {
	return &ObjectsClassReferencesDeleteNoContent{}
}

/*
ObjectsClassReferencesDeleteNoContent describes a response with status code 204, with default header values.

Reference deleted successfully.
*/
type ObjectsClassReferencesDeleteNoContent struct {
}

// IsSuccess returns true when this objects class references delete no content response has a 2xx status code
func (o *ObjectsClassReferencesDeleteNoContent) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this objects class references delete no content response has a 3xx status code
func (o *ObjectsClassReferencesDeleteNoContent) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects class references delete no content response has a 4xx status code
func (o *ObjectsClassReferencesDeleteNoContent) IsClientError() bool {
	return false
}

// IsServerError returns true when this objects class references delete no content response has a 5xx status code
func (o *ObjectsClassReferencesDeleteNoContent) IsServerError() bool {
	return false
}

// IsCode returns true when this objects class references delete no content response a status code equal to that given
func (o *ObjectsClassReferencesDeleteNoContent) IsCode(code int) bool {
	return code == 204
}

// Code gets the status code for the objects class references delete no content response
func (o *ObjectsClassReferencesDeleteNoContent) Code() int {
	return 204
}

func (o *ObjectsClassReferencesDeleteNoContent) Error() string {
	return fmt.Sprintf("[DELETE /objects/{className}/{id}/references/{propertyName}][%d] objectsClassReferencesDeleteNoContent ", 204)
}

func (o *ObjectsClassReferencesDeleteNoContent) String() string {
	return fmt.Sprintf("[DELETE /objects/{className}/{id}/references/{propertyName}][%d] objectsClassReferencesDeleteNoContent ", 204)
}

func (o *ObjectsClassReferencesDeleteNoContent) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewObjectsClassReferencesDeleteBadRequest creates a ObjectsClassReferencesDeleteBadRequest with default headers values
func NewObjectsClassReferencesDeleteBadRequest() *ObjectsClassReferencesDeleteBadRequest {
	return &ObjectsClassReferencesDeleteBadRequest{}
}

/*
ObjectsClassReferencesDeleteBadRequest describes a response with status code 400, with default header values.

Malformed request.
*/
type ObjectsClassReferencesDeleteBadRequest struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this objects class references delete bad request response has a 2xx status code
func (o *ObjectsClassReferencesDeleteBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects class references delete bad request response has a 3xx status code
func (o *ObjectsClassReferencesDeleteBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects class references delete bad request response has a 4xx status code
func (o *ObjectsClassReferencesDeleteBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this objects class references delete bad request response has a 5xx status code
func (o *ObjectsClassReferencesDeleteBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this objects class references delete bad request response a status code equal to that given
func (o *ObjectsClassReferencesDeleteBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the objects class references delete bad request response
func (o *ObjectsClassReferencesDeleteBadRequest) Code() int {
	return 400
}

func (o *ObjectsClassReferencesDeleteBadRequest) Error() string {
	return fmt.Sprintf("[DELETE /objects/{className}/{id}/references/{propertyName}][%d] objectsClassReferencesDeleteBadRequest  %+v", 400, o.Payload)
}

func (o *ObjectsClassReferencesDeleteBadRequest) String() string {
	return fmt.Sprintf("[DELETE /objects/{className}/{id}/references/{propertyName}][%d] objectsClassReferencesDeleteBadRequest  %+v", 400, o.Payload)
}

func (o *ObjectsClassReferencesDeleteBadRequest) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ObjectsClassReferencesDeleteBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewObjectsClassReferencesDeleteUnauthorized creates a ObjectsClassReferencesDeleteUnauthorized with default headers values
func NewObjectsClassReferencesDeleteUnauthorized() *ObjectsClassReferencesDeleteUnauthorized {
	return &ObjectsClassReferencesDeleteUnauthorized{}
}

/*
ObjectsClassReferencesDeleteUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type ObjectsClassReferencesDeleteUnauthorized struct {
}

// IsSuccess returns true when this objects class references delete unauthorized response has a 2xx status code
func (o *ObjectsClassReferencesDeleteUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects class references delete unauthorized response has a 3xx status code
func (o *ObjectsClassReferencesDeleteUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects class references delete unauthorized response has a 4xx status code
func (o *ObjectsClassReferencesDeleteUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this objects class references delete unauthorized response has a 5xx status code
func (o *ObjectsClassReferencesDeleteUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this objects class references delete unauthorized response a status code equal to that given
func (o *ObjectsClassReferencesDeleteUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the objects class references delete unauthorized response
func (o *ObjectsClassReferencesDeleteUnauthorized) Code() int {
	return 401
}

func (o *ObjectsClassReferencesDeleteUnauthorized) Error() string {
	return fmt.Sprintf("[DELETE /objects/{className}/{id}/references/{propertyName}][%d] objectsClassReferencesDeleteUnauthorized ", 401)
}

func (o *ObjectsClassReferencesDeleteUnauthorized) String() string {
	return fmt.Sprintf("[DELETE /objects/{className}/{id}/references/{propertyName}][%d] objectsClassReferencesDeleteUnauthorized ", 401)
}

func (o *ObjectsClassReferencesDeleteUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewObjectsClassReferencesDeleteForbidden creates a ObjectsClassReferencesDeleteForbidden with default headers values
func NewObjectsClassReferencesDeleteForbidden() *ObjectsClassReferencesDeleteForbidden {
	return &ObjectsClassReferencesDeleteForbidden{}
}

/*
ObjectsClassReferencesDeleteForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type ObjectsClassReferencesDeleteForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this objects class references delete forbidden response has a 2xx status code
func (o *ObjectsClassReferencesDeleteForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects class references delete forbidden response has a 3xx status code
func (o *ObjectsClassReferencesDeleteForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects class references delete forbidden response has a 4xx status code
func (o *ObjectsClassReferencesDeleteForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this objects class references delete forbidden response has a 5xx status code
func (o *ObjectsClassReferencesDeleteForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this objects class references delete forbidden response a status code equal to that given
func (o *ObjectsClassReferencesDeleteForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the objects class references delete forbidden response
func (o *ObjectsClassReferencesDeleteForbidden) Code() int {
	return 403
}

func (o *ObjectsClassReferencesDeleteForbidden) Error() string {
	return fmt.Sprintf("[DELETE /objects/{className}/{id}/references/{propertyName}][%d] objectsClassReferencesDeleteForbidden  %+v", 403, o.Payload)
}

func (o *ObjectsClassReferencesDeleteForbidden) String() string {
	return fmt.Sprintf("[DELETE /objects/{className}/{id}/references/{propertyName}][%d] objectsClassReferencesDeleteForbidden  %+v", 403, o.Payload)
}

func (o *ObjectsClassReferencesDeleteForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ObjectsClassReferencesDeleteForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewObjectsClassReferencesDeleteNotFound creates a ObjectsClassReferencesDeleteNotFound with default headers values
func NewObjectsClassReferencesDeleteNotFound() *ObjectsClassReferencesDeleteNotFound {
	return &ObjectsClassReferencesDeleteNotFound{}
}

/*
ObjectsClassReferencesDeleteNotFound describes a response with status code 404, with default header values.

Object or reference not found.
*/
type ObjectsClassReferencesDeleteNotFound struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this objects class references delete not found response has a 2xx status code
func (o *ObjectsClassReferencesDeleteNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects class references delete not found response has a 3xx status code
func (o *ObjectsClassReferencesDeleteNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects class references delete not found response has a 4xx status code
func (o *ObjectsClassReferencesDeleteNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this objects class references delete not found response has a 5xx status code
func (o *ObjectsClassReferencesDeleteNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this objects class references delete not found response a status code equal to that given
func (o *ObjectsClassReferencesDeleteNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the objects class references delete not found response
func (o *ObjectsClassReferencesDeleteNotFound) Code() int {
	return 404
}

func (o *ObjectsClassReferencesDeleteNotFound) Error() string {
	return fmt.Sprintf("[DELETE /objects/{className}/{id}/references/{propertyName}][%d] objectsClassReferencesDeleteNotFound  %+v", 404, o.Payload)
}

func (o *ObjectsClassReferencesDeleteNotFound) String() string {
	return fmt.Sprintf("[DELETE /objects/{className}/{id}/references/{propertyName}][%d] objectsClassReferencesDeleteNotFound  %+v", 404, o.Payload)
}

func (o *ObjectsClassReferencesDeleteNotFound) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ObjectsClassReferencesDeleteNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewObjectsClassReferencesDeleteUnprocessableEntity creates a ObjectsClassReferencesDeleteUnprocessableEntity with default headers values
func NewObjectsClassReferencesDeleteUnprocessableEntity() *ObjectsClassReferencesDeleteUnprocessableEntity {
	return &ObjectsClassReferencesDeleteUnprocessableEntity{}
}

/*
ObjectsClassReferencesDeleteUnprocessableEntity describes a response with status code 422, with default header values.

The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request. Ensure the property exists and is a reference type.
*/
type ObjectsClassReferencesDeleteUnprocessableEntity struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this objects class references delete unprocessable entity response has a 2xx status code
func (o *ObjectsClassReferencesDeleteUnprocessableEntity) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects class references delete unprocessable entity response has a 3xx status code
func (o *ObjectsClassReferencesDeleteUnprocessableEntity) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects class references delete unprocessable entity response has a 4xx status code
func (o *ObjectsClassReferencesDeleteUnprocessableEntity) IsClientError() bool {
	return true
}

// IsServerError returns true when this objects class references delete unprocessable entity response has a 5xx status code
func (o *ObjectsClassReferencesDeleteUnprocessableEntity) IsServerError() bool {
	return false
}

// IsCode returns true when this objects class references delete unprocessable entity response a status code equal to that given
func (o *ObjectsClassReferencesDeleteUnprocessableEntity) IsCode(code int) bool {
	return code == 422
}

// Code gets the status code for the objects class references delete unprocessable entity response
func (o *ObjectsClassReferencesDeleteUnprocessableEntity) Code() int {
	return 422
}

func (o *ObjectsClassReferencesDeleteUnprocessableEntity) Error() string {
	return fmt.Sprintf("[DELETE /objects/{className}/{id}/references/{propertyName}][%d] objectsClassReferencesDeleteUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *ObjectsClassReferencesDeleteUnprocessableEntity) String() string {
	return fmt.Sprintf("[DELETE /objects/{className}/{id}/references/{propertyName}][%d] objectsClassReferencesDeleteUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *ObjectsClassReferencesDeleteUnprocessableEntity) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ObjectsClassReferencesDeleteUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewObjectsClassReferencesDeleteInternalServerError creates a ObjectsClassReferencesDeleteInternalServerError with default headers values
func NewObjectsClassReferencesDeleteInternalServerError() *ObjectsClassReferencesDeleteInternalServerError {
	return &ObjectsClassReferencesDeleteInternalServerError{}
}

/*
ObjectsClassReferencesDeleteInternalServerError describes a response with status code 500, with default header values.

An error occurred while trying to fulfill the request. Check the ErrorResponse for details.
*/
type ObjectsClassReferencesDeleteInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this objects class references delete internal server error response has a 2xx status code
func (o *ObjectsClassReferencesDeleteInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects class references delete internal server error response has a 3xx status code
func (o *ObjectsClassReferencesDeleteInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects class references delete internal server error response has a 4xx status code
func (o *ObjectsClassReferencesDeleteInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this objects class references delete internal server error response has a 5xx status code
func (o *ObjectsClassReferencesDeleteInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this objects class references delete internal server error response a status code equal to that given
func (o *ObjectsClassReferencesDeleteInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the objects class references delete internal server error response
func (o *ObjectsClassReferencesDeleteInternalServerError) Code() int {
	return 500
}

func (o *ObjectsClassReferencesDeleteInternalServerError) Error() string {
	return fmt.Sprintf("[DELETE /objects/{className}/{id}/references/{propertyName}][%d] objectsClassReferencesDeleteInternalServerError  %+v", 500, o.Payload)
}

func (o *ObjectsClassReferencesDeleteInternalServerError) String() string {
	return fmt.Sprintf("[DELETE /objects/{className}/{id}/references/{propertyName}][%d] objectsClassReferencesDeleteInternalServerError  %+v", 500, o.Payload)
}

func (o *ObjectsClassReferencesDeleteInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ObjectsClassReferencesDeleteInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
