//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package replication

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// CancelReplicationReader is a Reader for the CancelReplication structure.
type CancelReplicationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CancelReplicationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 204:
		result := NewCancelReplicationNoContent()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewCancelReplicationUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewCancelReplicationForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewCancelReplicationNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewCancelReplicationConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 422:
		result := NewCancelReplicationUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewCancelReplicationInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 501:
		result := NewCancelReplicationNotImplemented()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewCancelReplicationNoContent creates a CancelReplicationNoContent with default headers values
func NewCancelReplicationNoContent() *CancelReplicationNoContent {
	return &CancelReplicationNoContent{}
}

/*
CancelReplicationNoContent describes a response with status code 204, with default header values.

Successfully cancelled.
*/
type CancelReplicationNoContent struct {
}

// IsSuccess returns true when this cancel replication no content response has a 2xx status code
func (o *CancelReplicationNoContent) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cancel replication no content response has a 3xx status code
func (o *CancelReplicationNoContent) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cancel replication no content response has a 4xx status code
func (o *CancelReplicationNoContent) IsClientError() bool {
	return false
}

// IsServerError returns true when this cancel replication no content response has a 5xx status code
func (o *CancelReplicationNoContent) IsServerError() bool {
	return false
}

// IsCode returns true when this cancel replication no content response a status code equal to that given
func (o *CancelReplicationNoContent) IsCode(code int) bool {
	return code == 204
}

// Code gets the status code for the cancel replication no content response
func (o *CancelReplicationNoContent) Code() int {
	return 204
}

func (o *CancelReplicationNoContent) Error() string {
	return fmt.Sprintf("[POST /replication/replicate/{id}/cancel][%d] cancelReplicationNoContent ", 204)
}

func (o *CancelReplicationNoContent) String() string {
	return fmt.Sprintf("[POST /replication/replicate/{id}/cancel][%d] cancelReplicationNoContent ", 204)
}

func (o *CancelReplicationNoContent) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewCancelReplicationUnauthorized creates a CancelReplicationUnauthorized with default headers values
func NewCancelReplicationUnauthorized() *CancelReplicationUnauthorized {
	return &CancelReplicationUnauthorized{}
}

/*
CancelReplicationUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type CancelReplicationUnauthorized struct {
}

// IsSuccess returns true when this cancel replication unauthorized response has a 2xx status code
func (o *CancelReplicationUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this cancel replication unauthorized response has a 3xx status code
func (o *CancelReplicationUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cancel replication unauthorized response has a 4xx status code
func (o *CancelReplicationUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this cancel replication unauthorized response has a 5xx status code
func (o *CancelReplicationUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this cancel replication unauthorized response a status code equal to that given
func (o *CancelReplicationUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the cancel replication unauthorized response
func (o *CancelReplicationUnauthorized) Code() int {
	return 401
}

func (o *CancelReplicationUnauthorized) Error() string {
	return fmt.Sprintf("[POST /replication/replicate/{id}/cancel][%d] cancelReplicationUnauthorized ", 401)
}

func (o *CancelReplicationUnauthorized) String() string {
	return fmt.Sprintf("[POST /replication/replicate/{id}/cancel][%d] cancelReplicationUnauthorized ", 401)
}

func (o *CancelReplicationUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewCancelReplicationForbidden creates a CancelReplicationForbidden with default headers values
func NewCancelReplicationForbidden() *CancelReplicationForbidden {
	return &CancelReplicationForbidden{}
}

/*
CancelReplicationForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type CancelReplicationForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cancel replication forbidden response has a 2xx status code
func (o *CancelReplicationForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this cancel replication forbidden response has a 3xx status code
func (o *CancelReplicationForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cancel replication forbidden response has a 4xx status code
func (o *CancelReplicationForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this cancel replication forbidden response has a 5xx status code
func (o *CancelReplicationForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this cancel replication forbidden response a status code equal to that given
func (o *CancelReplicationForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the cancel replication forbidden response
func (o *CancelReplicationForbidden) Code() int {
	return 403
}

func (o *CancelReplicationForbidden) Error() string {
	return fmt.Sprintf("[POST /replication/replicate/{id}/cancel][%d] cancelReplicationForbidden  %+v", 403, o.Payload)
}

func (o *CancelReplicationForbidden) String() string {
	return fmt.Sprintf("[POST /replication/replicate/{id}/cancel][%d] cancelReplicationForbidden  %+v", 403, o.Payload)
}

func (o *CancelReplicationForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *CancelReplicationForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCancelReplicationNotFound creates a CancelReplicationNotFound with default headers values
func NewCancelReplicationNotFound() *CancelReplicationNotFound {
	return &CancelReplicationNotFound{}
}

/*
CancelReplicationNotFound describes a response with status code 404, with default header values.

Shard replica operation not found.
*/
type CancelReplicationNotFound struct {
}

// IsSuccess returns true when this cancel replication not found response has a 2xx status code
func (o *CancelReplicationNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this cancel replication not found response has a 3xx status code
func (o *CancelReplicationNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cancel replication not found response has a 4xx status code
func (o *CancelReplicationNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this cancel replication not found response has a 5xx status code
func (o *CancelReplicationNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this cancel replication not found response a status code equal to that given
func (o *CancelReplicationNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the cancel replication not found response
func (o *CancelReplicationNotFound) Code() int {
	return 404
}

func (o *CancelReplicationNotFound) Error() string {
	return fmt.Sprintf("[POST /replication/replicate/{id}/cancel][%d] cancelReplicationNotFound ", 404)
}

func (o *CancelReplicationNotFound) String() string {
	return fmt.Sprintf("[POST /replication/replicate/{id}/cancel][%d] cancelReplicationNotFound ", 404)
}

func (o *CancelReplicationNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewCancelReplicationConflict creates a CancelReplicationConflict with default headers values
func NewCancelReplicationConflict() *CancelReplicationConflict {
	return &CancelReplicationConflict{}
}

/*
CancelReplicationConflict describes a response with status code 409, with default header values.

The operation is not in a cancellable state, e.g. it is READY or is a MOVE op in the DEHYDRATING state.
*/
type CancelReplicationConflict struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cancel replication conflict response has a 2xx status code
func (o *CancelReplicationConflict) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this cancel replication conflict response has a 3xx status code
func (o *CancelReplicationConflict) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cancel replication conflict response has a 4xx status code
func (o *CancelReplicationConflict) IsClientError() bool {
	return true
}

// IsServerError returns true when this cancel replication conflict response has a 5xx status code
func (o *CancelReplicationConflict) IsServerError() bool {
	return false
}

// IsCode returns true when this cancel replication conflict response a status code equal to that given
func (o *CancelReplicationConflict) IsCode(code int) bool {
	return code == 409
}

// Code gets the status code for the cancel replication conflict response
func (o *CancelReplicationConflict) Code() int {
	return 409
}

func (o *CancelReplicationConflict) Error() string {
	return fmt.Sprintf("[POST /replication/replicate/{id}/cancel][%d] cancelReplicationConflict  %+v", 409, o.Payload)
}

func (o *CancelReplicationConflict) String() string {
	return fmt.Sprintf("[POST /replication/replicate/{id}/cancel][%d] cancelReplicationConflict  %+v", 409, o.Payload)
}

func (o *CancelReplicationConflict) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *CancelReplicationConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCancelReplicationUnprocessableEntity creates a CancelReplicationUnprocessableEntity with default headers values
func NewCancelReplicationUnprocessableEntity() *CancelReplicationUnprocessableEntity {
	return &CancelReplicationUnprocessableEntity{}
}

/*
CancelReplicationUnprocessableEntity describes a response with status code 422, with default header values.

The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.
*/
type CancelReplicationUnprocessableEntity struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cancel replication unprocessable entity response has a 2xx status code
func (o *CancelReplicationUnprocessableEntity) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this cancel replication unprocessable entity response has a 3xx status code
func (o *CancelReplicationUnprocessableEntity) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cancel replication unprocessable entity response has a 4xx status code
func (o *CancelReplicationUnprocessableEntity) IsClientError() bool {
	return true
}

// IsServerError returns true when this cancel replication unprocessable entity response has a 5xx status code
func (o *CancelReplicationUnprocessableEntity) IsServerError() bool {
	return false
}

// IsCode returns true when this cancel replication unprocessable entity response a status code equal to that given
func (o *CancelReplicationUnprocessableEntity) IsCode(code int) bool {
	return code == 422
}

// Code gets the status code for the cancel replication unprocessable entity response
func (o *CancelReplicationUnprocessableEntity) Code() int {
	return 422
}

func (o *CancelReplicationUnprocessableEntity) Error() string {
	return fmt.Sprintf("[POST /replication/replicate/{id}/cancel][%d] cancelReplicationUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *CancelReplicationUnprocessableEntity) String() string {
	return fmt.Sprintf("[POST /replication/replicate/{id}/cancel][%d] cancelReplicationUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *CancelReplicationUnprocessableEntity) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *CancelReplicationUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCancelReplicationInternalServerError creates a CancelReplicationInternalServerError with default headers values
func NewCancelReplicationInternalServerError() *CancelReplicationInternalServerError {
	return &CancelReplicationInternalServerError{}
}

/*
CancelReplicationInternalServerError describes a response with status code 500, with default header values.

An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.
*/
type CancelReplicationInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cancel replication internal server error response has a 2xx status code
func (o *CancelReplicationInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this cancel replication internal server error response has a 3xx status code
func (o *CancelReplicationInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cancel replication internal server error response has a 4xx status code
func (o *CancelReplicationInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this cancel replication internal server error response has a 5xx status code
func (o *CancelReplicationInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this cancel replication internal server error response a status code equal to that given
func (o *CancelReplicationInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the cancel replication internal server error response
func (o *CancelReplicationInternalServerError) Code() int {
	return 500
}

func (o *CancelReplicationInternalServerError) Error() string {
	return fmt.Sprintf("[POST /replication/replicate/{id}/cancel][%d] cancelReplicationInternalServerError  %+v", 500, o.Payload)
}

func (o *CancelReplicationInternalServerError) String() string {
	return fmt.Sprintf("[POST /replication/replicate/{id}/cancel][%d] cancelReplicationInternalServerError  %+v", 500, o.Payload)
}

func (o *CancelReplicationInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *CancelReplicationInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCancelReplicationNotImplemented creates a CancelReplicationNotImplemented with default headers values
func NewCancelReplicationNotImplemented() *CancelReplicationNotImplemented {
	return &CancelReplicationNotImplemented{}
}

/*
CancelReplicationNotImplemented describes a response with status code 501, with default header values.

Replica movement operations are disabled.
*/
type CancelReplicationNotImplemented struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cancel replication not implemented response has a 2xx status code
func (o *CancelReplicationNotImplemented) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this cancel replication not implemented response has a 3xx status code
func (o *CancelReplicationNotImplemented) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cancel replication not implemented response has a 4xx status code
func (o *CancelReplicationNotImplemented) IsClientError() bool {
	return false
}

// IsServerError returns true when this cancel replication not implemented response has a 5xx status code
func (o *CancelReplicationNotImplemented) IsServerError() bool {
	return true
}

// IsCode returns true when this cancel replication not implemented response a status code equal to that given
func (o *CancelReplicationNotImplemented) IsCode(code int) bool {
	return code == 501
}

// Code gets the status code for the cancel replication not implemented response
func (o *CancelReplicationNotImplemented) Code() int {
	return 501
}

func (o *CancelReplicationNotImplemented) Error() string {
	return fmt.Sprintf("[POST /replication/replicate/{id}/cancel][%d] cancelReplicationNotImplemented  %+v", 501, o.Payload)
}

func (o *CancelReplicationNotImplemented) String() string {
	return fmt.Sprintf("[POST /replication/replicate/{id}/cancel][%d] cancelReplicationNotImplemented  %+v", 501, o.Payload)
}

func (o *CancelReplicationNotImplemented) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *CancelReplicationNotImplemented) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
