//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package replication

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// DeleteAllReplicationsReader is a Reader for the DeleteAllReplications structure.
type DeleteAllReplicationsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteAllReplicationsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 204:
		result := NewDeleteAllReplicationsNoContent()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewDeleteAllReplicationsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewDeleteAllReplicationsUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewDeleteAllReplicationsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 422:
		result := NewDeleteAllReplicationsUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewDeleteAllReplicationsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 501:
		result := NewDeleteAllReplicationsNotImplemented()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewDeleteAllReplicationsNoContent creates a DeleteAllReplicationsNoContent with default headers values
func NewDeleteAllReplicationsNoContent() *DeleteAllReplicationsNoContent {
	return &DeleteAllReplicationsNoContent{}
}

/*
DeleteAllReplicationsNoContent describes a response with status code 204, with default header values.

Replication operation registered successfully
*/
type DeleteAllReplicationsNoContent struct {
}

// IsSuccess returns true when this delete all replications no content response has a 2xx status code
func (o *DeleteAllReplicationsNoContent) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete all replications no content response has a 3xx status code
func (o *DeleteAllReplicationsNoContent) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete all replications no content response has a 4xx status code
func (o *DeleteAllReplicationsNoContent) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete all replications no content response has a 5xx status code
func (o *DeleteAllReplicationsNoContent) IsServerError() bool {
	return false
}

// IsCode returns true when this delete all replications no content response a status code equal to that given
func (o *DeleteAllReplicationsNoContent) IsCode(code int) bool {
	return code == 204
}

// Code gets the status code for the delete all replications no content response
func (o *DeleteAllReplicationsNoContent) Code() int {
	return 204
}

func (o *DeleteAllReplicationsNoContent) Error() string {
	return fmt.Sprintf("[DELETE /replication/replicate][%d] deleteAllReplicationsNoContent ", 204)
}

func (o *DeleteAllReplicationsNoContent) String() string {
	return fmt.Sprintf("[DELETE /replication/replicate][%d] deleteAllReplicationsNoContent ", 204)
}

func (o *DeleteAllReplicationsNoContent) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDeleteAllReplicationsBadRequest creates a DeleteAllReplicationsBadRequest with default headers values
func NewDeleteAllReplicationsBadRequest() *DeleteAllReplicationsBadRequest {
	return &DeleteAllReplicationsBadRequest{}
}

/*
DeleteAllReplicationsBadRequest describes a response with status code 400, with default header values.

Malformed request.
*/
type DeleteAllReplicationsBadRequest struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this delete all replications bad request response has a 2xx status code
func (o *DeleteAllReplicationsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete all replications bad request response has a 3xx status code
func (o *DeleteAllReplicationsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete all replications bad request response has a 4xx status code
func (o *DeleteAllReplicationsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete all replications bad request response has a 5xx status code
func (o *DeleteAllReplicationsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this delete all replications bad request response a status code equal to that given
func (o *DeleteAllReplicationsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the delete all replications bad request response
func (o *DeleteAllReplicationsBadRequest) Code() int {
	return 400
}

func (o *DeleteAllReplicationsBadRequest) Error() string {
	return fmt.Sprintf("[DELETE /replication/replicate][%d] deleteAllReplicationsBadRequest  %+v", 400, o.Payload)
}

func (o *DeleteAllReplicationsBadRequest) String() string {
	return fmt.Sprintf("[DELETE /replication/replicate][%d] deleteAllReplicationsBadRequest  %+v", 400, o.Payload)
}

func (o *DeleteAllReplicationsBadRequest) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DeleteAllReplicationsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteAllReplicationsUnauthorized creates a DeleteAllReplicationsUnauthorized with default headers values
func NewDeleteAllReplicationsUnauthorized() *DeleteAllReplicationsUnauthorized {
	return &DeleteAllReplicationsUnauthorized{}
}

/*
DeleteAllReplicationsUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type DeleteAllReplicationsUnauthorized struct {
}

// IsSuccess returns true when this delete all replications unauthorized response has a 2xx status code
func (o *DeleteAllReplicationsUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete all replications unauthorized response has a 3xx status code
func (o *DeleteAllReplicationsUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete all replications unauthorized response has a 4xx status code
func (o *DeleteAllReplicationsUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete all replications unauthorized response has a 5xx status code
func (o *DeleteAllReplicationsUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this delete all replications unauthorized response a status code equal to that given
func (o *DeleteAllReplicationsUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the delete all replications unauthorized response
func (o *DeleteAllReplicationsUnauthorized) Code() int {
	return 401
}

func (o *DeleteAllReplicationsUnauthorized) Error() string {
	return fmt.Sprintf("[DELETE /replication/replicate][%d] deleteAllReplicationsUnauthorized ", 401)
}

func (o *DeleteAllReplicationsUnauthorized) String() string {
	return fmt.Sprintf("[DELETE /replication/replicate][%d] deleteAllReplicationsUnauthorized ", 401)
}

func (o *DeleteAllReplicationsUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDeleteAllReplicationsForbidden creates a DeleteAllReplicationsForbidden with default headers values
func NewDeleteAllReplicationsForbidden() *DeleteAllReplicationsForbidden {
	return &DeleteAllReplicationsForbidden{}
}

/*
DeleteAllReplicationsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type DeleteAllReplicationsForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this delete all replications forbidden response has a 2xx status code
func (o *DeleteAllReplicationsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete all replications forbidden response has a 3xx status code
func (o *DeleteAllReplicationsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete all replications forbidden response has a 4xx status code
func (o *DeleteAllReplicationsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete all replications forbidden response has a 5xx status code
func (o *DeleteAllReplicationsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this delete all replications forbidden response a status code equal to that given
func (o *DeleteAllReplicationsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the delete all replications forbidden response
func (o *DeleteAllReplicationsForbidden) Code() int {
	return 403
}

func (o *DeleteAllReplicationsForbidden) Error() string {
	return fmt.Sprintf("[DELETE /replication/replicate][%d] deleteAllReplicationsForbidden  %+v", 403, o.Payload)
}

func (o *DeleteAllReplicationsForbidden) String() string {
	return fmt.Sprintf("[DELETE /replication/replicate][%d] deleteAllReplicationsForbidden  %+v", 403, o.Payload)
}

func (o *DeleteAllReplicationsForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DeleteAllReplicationsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteAllReplicationsUnprocessableEntity creates a DeleteAllReplicationsUnprocessableEntity with default headers values
func NewDeleteAllReplicationsUnprocessableEntity() *DeleteAllReplicationsUnprocessableEntity {
	return &DeleteAllReplicationsUnprocessableEntity{}
}

/*
DeleteAllReplicationsUnprocessableEntity describes a response with status code 422, with default header values.

The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.
*/
type DeleteAllReplicationsUnprocessableEntity struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this delete all replications unprocessable entity response has a 2xx status code
func (o *DeleteAllReplicationsUnprocessableEntity) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete all replications unprocessable entity response has a 3xx status code
func (o *DeleteAllReplicationsUnprocessableEntity) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete all replications unprocessable entity response has a 4xx status code
func (o *DeleteAllReplicationsUnprocessableEntity) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete all replications unprocessable entity response has a 5xx status code
func (o *DeleteAllReplicationsUnprocessableEntity) IsServerError() bool {
	return false
}

// IsCode returns true when this delete all replications unprocessable entity response a status code equal to that given
func (o *DeleteAllReplicationsUnprocessableEntity) IsCode(code int) bool {
	return code == 422
}

// Code gets the status code for the delete all replications unprocessable entity response
func (o *DeleteAllReplicationsUnprocessableEntity) Code() int {
	return 422
}

func (o *DeleteAllReplicationsUnprocessableEntity) Error() string {
	return fmt.Sprintf("[DELETE /replication/replicate][%d] deleteAllReplicationsUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *DeleteAllReplicationsUnprocessableEntity) String() string {
	return fmt.Sprintf("[DELETE /replication/replicate][%d] deleteAllReplicationsUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *DeleteAllReplicationsUnprocessableEntity) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DeleteAllReplicationsUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteAllReplicationsInternalServerError creates a DeleteAllReplicationsInternalServerError with default headers values
func NewDeleteAllReplicationsInternalServerError() *DeleteAllReplicationsInternalServerError {
	return &DeleteAllReplicationsInternalServerError{}
}

/*
DeleteAllReplicationsInternalServerError describes a response with status code 500, with default header values.

An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.
*/
type DeleteAllReplicationsInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this delete all replications internal server error response has a 2xx status code
func (o *DeleteAllReplicationsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete all replications internal server error response has a 3xx status code
func (o *DeleteAllReplicationsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete all replications internal server error response has a 4xx status code
func (o *DeleteAllReplicationsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete all replications internal server error response has a 5xx status code
func (o *DeleteAllReplicationsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this delete all replications internal server error response a status code equal to that given
func (o *DeleteAllReplicationsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the delete all replications internal server error response
func (o *DeleteAllReplicationsInternalServerError) Code() int {
	return 500
}

func (o *DeleteAllReplicationsInternalServerError) Error() string {
	return fmt.Sprintf("[DELETE /replication/replicate][%d] deleteAllReplicationsInternalServerError  %+v", 500, o.Payload)
}

func (o *DeleteAllReplicationsInternalServerError) String() string {
	return fmt.Sprintf("[DELETE /replication/replicate][%d] deleteAllReplicationsInternalServerError  %+v", 500, o.Payload)
}

func (o *DeleteAllReplicationsInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DeleteAllReplicationsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteAllReplicationsNotImplemented creates a DeleteAllReplicationsNotImplemented with default headers values
func NewDeleteAllReplicationsNotImplemented() *DeleteAllReplicationsNotImplemented {
	return &DeleteAllReplicationsNotImplemented{}
}

/*
DeleteAllReplicationsNotImplemented describes a response with status code 501, with default header values.

Replica movement operations are disabled.
*/
type DeleteAllReplicationsNotImplemented struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this delete all replications not implemented response has a 2xx status code
func (o *DeleteAllReplicationsNotImplemented) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete all replications not implemented response has a 3xx status code
func (o *DeleteAllReplicationsNotImplemented) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete all replications not implemented response has a 4xx status code
func (o *DeleteAllReplicationsNotImplemented) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete all replications not implemented response has a 5xx status code
func (o *DeleteAllReplicationsNotImplemented) IsServerError() bool {
	return true
}

// IsCode returns true when this delete all replications not implemented response a status code equal to that given
func (o *DeleteAllReplicationsNotImplemented) IsCode(code int) bool {
	return code == 501
}

// Code gets the status code for the delete all replications not implemented response
func (o *DeleteAllReplicationsNotImplemented) Code() int {
	return 501
}

func (o *DeleteAllReplicationsNotImplemented) Error() string {
	return fmt.Sprintf("[DELETE /replication/replicate][%d] deleteAllReplicationsNotImplemented  %+v", 501, o.Payload)
}

func (o *DeleteAllReplicationsNotImplemented) String() string {
	return fmt.Sprintf("[DELETE /replication/replicate][%d] deleteAllReplicationsNotImplemented  %+v", 501, o.Payload)
}

func (o *DeleteAllReplicationsNotImplemented) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DeleteAllReplicationsNotImplemented) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
