//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package replication

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// ForceDeleteReplicationsReader is a Reader for the ForceDeleteReplications structure.
type ForceDeleteReplicationsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ForceDeleteReplicationsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewForceDeleteReplicationsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewForceDeleteReplicationsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewForceDeleteReplicationsUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewForceDeleteReplicationsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 422:
		result := NewForceDeleteReplicationsUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewForceDeleteReplicationsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewForceDeleteReplicationsOK creates a ForceDeleteReplicationsOK with default headers values
func NewForceDeleteReplicationsOK() *ForceDeleteReplicationsOK {
	return &ForceDeleteReplicationsOK{}
}

/*
ForceDeleteReplicationsOK describes a response with status code 200, with default header values.

Replication operations force deleted successfully.
*/
type ForceDeleteReplicationsOK struct {
	Payload *models.ReplicationReplicateForceDeleteResponse
}

// IsSuccess returns true when this force delete replications o k response has a 2xx status code
func (o *ForceDeleteReplicationsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this force delete replications o k response has a 3xx status code
func (o *ForceDeleteReplicationsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this force delete replications o k response has a 4xx status code
func (o *ForceDeleteReplicationsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this force delete replications o k response has a 5xx status code
func (o *ForceDeleteReplicationsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this force delete replications o k response a status code equal to that given
func (o *ForceDeleteReplicationsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the force delete replications o k response
func (o *ForceDeleteReplicationsOK) Code() int {
	return 200
}

func (o *ForceDeleteReplicationsOK) Error() string {
	return fmt.Sprintf("[POST /replication/replicate/force-delete][%d] forceDeleteReplicationsOK  %+v", 200, o.Payload)
}

func (o *ForceDeleteReplicationsOK) String() string {
	return fmt.Sprintf("[POST /replication/replicate/force-delete][%d] forceDeleteReplicationsOK  %+v", 200, o.Payload)
}

func (o *ForceDeleteReplicationsOK) GetPayload() *models.ReplicationReplicateForceDeleteResponse {
	return o.Payload
}

func (o *ForceDeleteReplicationsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ReplicationReplicateForceDeleteResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewForceDeleteReplicationsBadRequest creates a ForceDeleteReplicationsBadRequest with default headers values
func NewForceDeleteReplicationsBadRequest() *ForceDeleteReplicationsBadRequest {
	return &ForceDeleteReplicationsBadRequest{}
}

/*
ForceDeleteReplicationsBadRequest describes a response with status code 400, with default header values.

Malformed request.
*/
type ForceDeleteReplicationsBadRequest struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this force delete replications bad request response has a 2xx status code
func (o *ForceDeleteReplicationsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this force delete replications bad request response has a 3xx status code
func (o *ForceDeleteReplicationsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this force delete replications bad request response has a 4xx status code
func (o *ForceDeleteReplicationsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this force delete replications bad request response has a 5xx status code
func (o *ForceDeleteReplicationsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this force delete replications bad request response a status code equal to that given
func (o *ForceDeleteReplicationsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the force delete replications bad request response
func (o *ForceDeleteReplicationsBadRequest) Code() int {
	return 400
}

func (o *ForceDeleteReplicationsBadRequest) Error() string {
	return fmt.Sprintf("[POST /replication/replicate/force-delete][%d] forceDeleteReplicationsBadRequest  %+v", 400, o.Payload)
}

func (o *ForceDeleteReplicationsBadRequest) String() string {
	return fmt.Sprintf("[POST /replication/replicate/force-delete][%d] forceDeleteReplicationsBadRequest  %+v", 400, o.Payload)
}

func (o *ForceDeleteReplicationsBadRequest) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ForceDeleteReplicationsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewForceDeleteReplicationsUnauthorized creates a ForceDeleteReplicationsUnauthorized with default headers values
func NewForceDeleteReplicationsUnauthorized() *ForceDeleteReplicationsUnauthorized {
	return &ForceDeleteReplicationsUnauthorized{}
}

/*
ForceDeleteReplicationsUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type ForceDeleteReplicationsUnauthorized struct {
}

// IsSuccess returns true when this force delete replications unauthorized response has a 2xx status code
func (o *ForceDeleteReplicationsUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this force delete replications unauthorized response has a 3xx status code
func (o *ForceDeleteReplicationsUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this force delete replications unauthorized response has a 4xx status code
func (o *ForceDeleteReplicationsUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this force delete replications unauthorized response has a 5xx status code
func (o *ForceDeleteReplicationsUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this force delete replications unauthorized response a status code equal to that given
func (o *ForceDeleteReplicationsUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the force delete replications unauthorized response
func (o *ForceDeleteReplicationsUnauthorized) Code() int {
	return 401
}

func (o *ForceDeleteReplicationsUnauthorized) Error() string {
	return fmt.Sprintf("[POST /replication/replicate/force-delete][%d] forceDeleteReplicationsUnauthorized ", 401)
}

func (o *ForceDeleteReplicationsUnauthorized) String() string {
	return fmt.Sprintf("[POST /replication/replicate/force-delete][%d] forceDeleteReplicationsUnauthorized ", 401)
}

func (o *ForceDeleteReplicationsUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewForceDeleteReplicationsForbidden creates a ForceDeleteReplicationsForbidden with default headers values
func NewForceDeleteReplicationsForbidden() *ForceDeleteReplicationsForbidden {
	return &ForceDeleteReplicationsForbidden{}
}

/*
ForceDeleteReplicationsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type ForceDeleteReplicationsForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this force delete replications forbidden response has a 2xx status code
func (o *ForceDeleteReplicationsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this force delete replications forbidden response has a 3xx status code
func (o *ForceDeleteReplicationsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this force delete replications forbidden response has a 4xx status code
func (o *ForceDeleteReplicationsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this force delete replications forbidden response has a 5xx status code
func (o *ForceDeleteReplicationsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this force delete replications forbidden response a status code equal to that given
func (o *ForceDeleteReplicationsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the force delete replications forbidden response
func (o *ForceDeleteReplicationsForbidden) Code() int {
	return 403
}

func (o *ForceDeleteReplicationsForbidden) Error() string {
	return fmt.Sprintf("[POST /replication/replicate/force-delete][%d] forceDeleteReplicationsForbidden  %+v", 403, o.Payload)
}

func (o *ForceDeleteReplicationsForbidden) String() string {
	return fmt.Sprintf("[POST /replication/replicate/force-delete][%d] forceDeleteReplicationsForbidden  %+v", 403, o.Payload)
}

func (o *ForceDeleteReplicationsForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ForceDeleteReplicationsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewForceDeleteReplicationsUnprocessableEntity creates a ForceDeleteReplicationsUnprocessableEntity with default headers values
func NewForceDeleteReplicationsUnprocessableEntity() *ForceDeleteReplicationsUnprocessableEntity {
	return &ForceDeleteReplicationsUnprocessableEntity{}
}

/*
ForceDeleteReplicationsUnprocessableEntity describes a response with status code 422, with default header values.

The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.
*/
type ForceDeleteReplicationsUnprocessableEntity struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this force delete replications unprocessable entity response has a 2xx status code
func (o *ForceDeleteReplicationsUnprocessableEntity) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this force delete replications unprocessable entity response has a 3xx status code
func (o *ForceDeleteReplicationsUnprocessableEntity) IsRedirect() bool {
	return false
}

// IsClientError returns true when this force delete replications unprocessable entity response has a 4xx status code
func (o *ForceDeleteReplicationsUnprocessableEntity) IsClientError() bool {
	return true
}

// IsServerError returns true when this force delete replications unprocessable entity response has a 5xx status code
func (o *ForceDeleteReplicationsUnprocessableEntity) IsServerError() bool {
	return false
}

// IsCode returns true when this force delete replications unprocessable entity response a status code equal to that given
func (o *ForceDeleteReplicationsUnprocessableEntity) IsCode(code int) bool {
	return code == 422
}

// Code gets the status code for the force delete replications unprocessable entity response
func (o *ForceDeleteReplicationsUnprocessableEntity) Code() int {
	return 422
}

func (o *ForceDeleteReplicationsUnprocessableEntity) Error() string {
	return fmt.Sprintf("[POST /replication/replicate/force-delete][%d] forceDeleteReplicationsUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *ForceDeleteReplicationsUnprocessableEntity) String() string {
	return fmt.Sprintf("[POST /replication/replicate/force-delete][%d] forceDeleteReplicationsUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *ForceDeleteReplicationsUnprocessableEntity) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ForceDeleteReplicationsUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewForceDeleteReplicationsInternalServerError creates a ForceDeleteReplicationsInternalServerError with default headers values
func NewForceDeleteReplicationsInternalServerError() *ForceDeleteReplicationsInternalServerError {
	return &ForceDeleteReplicationsInternalServerError{}
}

/*
ForceDeleteReplicationsInternalServerError describes a response with status code 500, with default header values.

An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.
*/
type ForceDeleteReplicationsInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this force delete replications internal server error response has a 2xx status code
func (o *ForceDeleteReplicationsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this force delete replications internal server error response has a 3xx status code
func (o *ForceDeleteReplicationsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this force delete replications internal server error response has a 4xx status code
func (o *ForceDeleteReplicationsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this force delete replications internal server error response has a 5xx status code
func (o *ForceDeleteReplicationsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this force delete replications internal server error response a status code equal to that given
func (o *ForceDeleteReplicationsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the force delete replications internal server error response
func (o *ForceDeleteReplicationsInternalServerError) Code() int {
	return 500
}

func (o *ForceDeleteReplicationsInternalServerError) Error() string {
	return fmt.Sprintf("[POST /replication/replicate/force-delete][%d] forceDeleteReplicationsInternalServerError  %+v", 500, o.Payload)
}

func (o *ForceDeleteReplicationsInternalServerError) String() string {
	return fmt.Sprintf("[POST /replication/replicate/force-delete][%d] forceDeleteReplicationsInternalServerError  %+v", 500, o.Payload)
}

func (o *ForceDeleteReplicationsInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ForceDeleteReplicationsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
