//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package replication

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetReplicationScalePlanParams creates a new GetReplicationScalePlanParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetReplicationScalePlanParams() *GetReplicationScalePlanParams {
	return &GetReplicationScalePlanParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetReplicationScalePlanParamsWithTimeout creates a new GetReplicationScalePlanParams object
// with the ability to set a timeout on a request.
func NewGetReplicationScalePlanParamsWithTimeout(timeout time.Duration) *GetReplicationScalePlanParams {
	return &GetReplicationScalePlanParams{
		timeout: timeout,
	}
}

// NewGetReplicationScalePlanParamsWithContext creates a new GetReplicationScalePlanParams object
// with the ability to set a context for a request.
func NewGetReplicationScalePlanParamsWithContext(ctx context.Context) *GetReplicationScalePlanParams {
	return &GetReplicationScalePlanParams{
		Context: ctx,
	}
}

// NewGetReplicationScalePlanParamsWithHTTPClient creates a new GetReplicationScalePlanParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetReplicationScalePlanParamsWithHTTPClient(client *http.Client) *GetReplicationScalePlanParams {
	return &GetReplicationScalePlanParams{
		HTTPClient: client,
	}
}

/*
GetReplicationScalePlanParams contains all the parameters to send to the API endpoint

	for the get replication scale plan operation.

	Typically these are written to a http.Request.
*/
type GetReplicationScalePlanParams struct {

	/* Collection.

	   The collection name to get the scaling plan for.
	*/
	Collection string

	/* ReplicationFactor.

	   The desired replication factor to scale to. Must be a positive integer greater than zero.
	*/
	ReplicationFactor int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get replication scale plan params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetReplicationScalePlanParams) WithDefaults() *GetReplicationScalePlanParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get replication scale plan params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetReplicationScalePlanParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get replication scale plan params
func (o *GetReplicationScalePlanParams) WithTimeout(timeout time.Duration) *GetReplicationScalePlanParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get replication scale plan params
func (o *GetReplicationScalePlanParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get replication scale plan params
func (o *GetReplicationScalePlanParams) WithContext(ctx context.Context) *GetReplicationScalePlanParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get replication scale plan params
func (o *GetReplicationScalePlanParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get replication scale plan params
func (o *GetReplicationScalePlanParams) WithHTTPClient(client *http.Client) *GetReplicationScalePlanParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get replication scale plan params
func (o *GetReplicationScalePlanParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCollection adds the collection to the get replication scale plan params
func (o *GetReplicationScalePlanParams) WithCollection(collection string) *GetReplicationScalePlanParams {
	o.SetCollection(collection)
	return o
}

// SetCollection adds the collection to the get replication scale plan params
func (o *GetReplicationScalePlanParams) SetCollection(collection string) {
	o.Collection = collection
}

// WithReplicationFactor adds the replicationFactor to the get replication scale plan params
func (o *GetReplicationScalePlanParams) WithReplicationFactor(replicationFactor int64) *GetReplicationScalePlanParams {
	o.SetReplicationFactor(replicationFactor)
	return o
}

// SetReplicationFactor adds the replicationFactor to the get replication scale plan params
func (o *GetReplicationScalePlanParams) SetReplicationFactor(replicationFactor int64) {
	o.ReplicationFactor = replicationFactor
}

// WriteToRequest writes these params to a swagger request
func (o *GetReplicationScalePlanParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// query param collection
	qrCollection := o.Collection
	qCollection := qrCollection
	if qCollection != "" {

		if err := r.SetQueryParam("collection", qCollection); err != nil {
			return err
		}
	}

	// query param replicationFactor
	qrReplicationFactor := o.ReplicationFactor
	qReplicationFactor := swag.FormatInt64(qrReplicationFactor)
	if qReplicationFactor != "" {

		if err := r.SetQueryParam("replicationFactor", qReplicationFactor); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
