//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package replication

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// GetReplicationScalePlanReader is a Reader for the GetReplicationScalePlan structure.
type GetReplicationScalePlanReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetReplicationScalePlanReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetReplicationScalePlanOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetReplicationScalePlanBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewGetReplicationScalePlanUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetReplicationScalePlanForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetReplicationScalePlanNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetReplicationScalePlanInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 501:
		result := NewGetReplicationScalePlanNotImplemented()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewGetReplicationScalePlanOK creates a GetReplicationScalePlanOK with default headers values
func NewGetReplicationScalePlanOK() *GetReplicationScalePlanOK {
	return &GetReplicationScalePlanOK{}
}

/*
GetReplicationScalePlanOK describes a response with status code 200, with default header values.

Replication scale plan showing node additions and removals per shard.
*/
type GetReplicationScalePlanOK struct {
	Payload *models.ReplicationScalePlan
}

// IsSuccess returns true when this get replication scale plan o k response has a 2xx status code
func (o *GetReplicationScalePlanOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get replication scale plan o k response has a 3xx status code
func (o *GetReplicationScalePlanOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get replication scale plan o k response has a 4xx status code
func (o *GetReplicationScalePlanOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get replication scale plan o k response has a 5xx status code
func (o *GetReplicationScalePlanOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get replication scale plan o k response a status code equal to that given
func (o *GetReplicationScalePlanOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get replication scale plan o k response
func (o *GetReplicationScalePlanOK) Code() int {
	return 200
}

func (o *GetReplicationScalePlanOK) Error() string {
	return fmt.Sprintf("[GET /replication/scale][%d] getReplicationScalePlanOK  %+v", 200, o.Payload)
}

func (o *GetReplicationScalePlanOK) String() string {
	return fmt.Sprintf("[GET /replication/scale][%d] getReplicationScalePlanOK  %+v", 200, o.Payload)
}

func (o *GetReplicationScalePlanOK) GetPayload() *models.ReplicationScalePlan {
	return o.Payload
}

func (o *GetReplicationScalePlanOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ReplicationScalePlan)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetReplicationScalePlanBadRequest creates a GetReplicationScalePlanBadRequest with default headers values
func NewGetReplicationScalePlanBadRequest() *GetReplicationScalePlanBadRequest {
	return &GetReplicationScalePlanBadRequest{}
}

/*
GetReplicationScalePlanBadRequest describes a response with status code 400, with default header values.

Bad request.
*/
type GetReplicationScalePlanBadRequest struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this get replication scale plan bad request response has a 2xx status code
func (o *GetReplicationScalePlanBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get replication scale plan bad request response has a 3xx status code
func (o *GetReplicationScalePlanBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get replication scale plan bad request response has a 4xx status code
func (o *GetReplicationScalePlanBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get replication scale plan bad request response has a 5xx status code
func (o *GetReplicationScalePlanBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get replication scale plan bad request response a status code equal to that given
func (o *GetReplicationScalePlanBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get replication scale plan bad request response
func (o *GetReplicationScalePlanBadRequest) Code() int {
	return 400
}

func (o *GetReplicationScalePlanBadRequest) Error() string {
	return fmt.Sprintf("[GET /replication/scale][%d] getReplicationScalePlanBadRequest  %+v", 400, o.Payload)
}

func (o *GetReplicationScalePlanBadRequest) String() string {
	return fmt.Sprintf("[GET /replication/scale][%d] getReplicationScalePlanBadRequest  %+v", 400, o.Payload)
}

func (o *GetReplicationScalePlanBadRequest) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GetReplicationScalePlanBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetReplicationScalePlanUnauthorized creates a GetReplicationScalePlanUnauthorized with default headers values
func NewGetReplicationScalePlanUnauthorized() *GetReplicationScalePlanUnauthorized {
	return &GetReplicationScalePlanUnauthorized{}
}

/*
GetReplicationScalePlanUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type GetReplicationScalePlanUnauthorized struct {
}

// IsSuccess returns true when this get replication scale plan unauthorized response has a 2xx status code
func (o *GetReplicationScalePlanUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get replication scale plan unauthorized response has a 3xx status code
func (o *GetReplicationScalePlanUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get replication scale plan unauthorized response has a 4xx status code
func (o *GetReplicationScalePlanUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get replication scale plan unauthorized response has a 5xx status code
func (o *GetReplicationScalePlanUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get replication scale plan unauthorized response a status code equal to that given
func (o *GetReplicationScalePlanUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get replication scale plan unauthorized response
func (o *GetReplicationScalePlanUnauthorized) Code() int {
	return 401
}

func (o *GetReplicationScalePlanUnauthorized) Error() string {
	return fmt.Sprintf("[GET /replication/scale][%d] getReplicationScalePlanUnauthorized ", 401)
}

func (o *GetReplicationScalePlanUnauthorized) String() string {
	return fmt.Sprintf("[GET /replication/scale][%d] getReplicationScalePlanUnauthorized ", 401)
}

func (o *GetReplicationScalePlanUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewGetReplicationScalePlanForbidden creates a GetReplicationScalePlanForbidden with default headers values
func NewGetReplicationScalePlanForbidden() *GetReplicationScalePlanForbidden {
	return &GetReplicationScalePlanForbidden{}
}

/*
GetReplicationScalePlanForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetReplicationScalePlanForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this get replication scale plan forbidden response has a 2xx status code
func (o *GetReplicationScalePlanForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get replication scale plan forbidden response has a 3xx status code
func (o *GetReplicationScalePlanForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get replication scale plan forbidden response has a 4xx status code
func (o *GetReplicationScalePlanForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get replication scale plan forbidden response has a 5xx status code
func (o *GetReplicationScalePlanForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get replication scale plan forbidden response a status code equal to that given
func (o *GetReplicationScalePlanForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get replication scale plan forbidden response
func (o *GetReplicationScalePlanForbidden) Code() int {
	return 403
}

func (o *GetReplicationScalePlanForbidden) Error() string {
	return fmt.Sprintf("[GET /replication/scale][%d] getReplicationScalePlanForbidden  %+v", 403, o.Payload)
}

func (o *GetReplicationScalePlanForbidden) String() string {
	return fmt.Sprintf("[GET /replication/scale][%d] getReplicationScalePlanForbidden  %+v", 403, o.Payload)
}

func (o *GetReplicationScalePlanForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GetReplicationScalePlanForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetReplicationScalePlanNotFound creates a GetReplicationScalePlanNotFound with default headers values
func NewGetReplicationScalePlanNotFound() *GetReplicationScalePlanNotFound {
	return &GetReplicationScalePlanNotFound{}
}

/*
GetReplicationScalePlanNotFound describes a response with status code 404, with default header values.

Collection not found.
*/
type GetReplicationScalePlanNotFound struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this get replication scale plan not found response has a 2xx status code
func (o *GetReplicationScalePlanNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get replication scale plan not found response has a 3xx status code
func (o *GetReplicationScalePlanNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get replication scale plan not found response has a 4xx status code
func (o *GetReplicationScalePlanNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get replication scale plan not found response has a 5xx status code
func (o *GetReplicationScalePlanNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get replication scale plan not found response a status code equal to that given
func (o *GetReplicationScalePlanNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get replication scale plan not found response
func (o *GetReplicationScalePlanNotFound) Code() int {
	return 404
}

func (o *GetReplicationScalePlanNotFound) Error() string {
	return fmt.Sprintf("[GET /replication/scale][%d] getReplicationScalePlanNotFound  %+v", 404, o.Payload)
}

func (o *GetReplicationScalePlanNotFound) String() string {
	return fmt.Sprintf("[GET /replication/scale][%d] getReplicationScalePlanNotFound  %+v", 404, o.Payload)
}

func (o *GetReplicationScalePlanNotFound) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GetReplicationScalePlanNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetReplicationScalePlanInternalServerError creates a GetReplicationScalePlanInternalServerError with default headers values
func NewGetReplicationScalePlanInternalServerError() *GetReplicationScalePlanInternalServerError {
	return &GetReplicationScalePlanInternalServerError{}
}

/*
GetReplicationScalePlanInternalServerError describes a response with status code 500, with default header values.

An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.
*/
type GetReplicationScalePlanInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this get replication scale plan internal server error response has a 2xx status code
func (o *GetReplicationScalePlanInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get replication scale plan internal server error response has a 3xx status code
func (o *GetReplicationScalePlanInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get replication scale plan internal server error response has a 4xx status code
func (o *GetReplicationScalePlanInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get replication scale plan internal server error response has a 5xx status code
func (o *GetReplicationScalePlanInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get replication scale plan internal server error response a status code equal to that given
func (o *GetReplicationScalePlanInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get replication scale plan internal server error response
func (o *GetReplicationScalePlanInternalServerError) Code() int {
	return 500
}

func (o *GetReplicationScalePlanInternalServerError) Error() string {
	return fmt.Sprintf("[GET /replication/scale][%d] getReplicationScalePlanInternalServerError  %+v", 500, o.Payload)
}

func (o *GetReplicationScalePlanInternalServerError) String() string {
	return fmt.Sprintf("[GET /replication/scale][%d] getReplicationScalePlanInternalServerError  %+v", 500, o.Payload)
}

func (o *GetReplicationScalePlanInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GetReplicationScalePlanInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetReplicationScalePlanNotImplemented creates a GetReplicationScalePlanNotImplemented with default headers values
func NewGetReplicationScalePlanNotImplemented() *GetReplicationScalePlanNotImplemented {
	return &GetReplicationScalePlanNotImplemented{}
}

/*
GetReplicationScalePlanNotImplemented describes a response with status code 501, with default header values.

Replica movement operations are disabled.
*/
type GetReplicationScalePlanNotImplemented struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this get replication scale plan not implemented response has a 2xx status code
func (o *GetReplicationScalePlanNotImplemented) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get replication scale plan not implemented response has a 3xx status code
func (o *GetReplicationScalePlanNotImplemented) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get replication scale plan not implemented response has a 4xx status code
func (o *GetReplicationScalePlanNotImplemented) IsClientError() bool {
	return false
}

// IsServerError returns true when this get replication scale plan not implemented response has a 5xx status code
func (o *GetReplicationScalePlanNotImplemented) IsServerError() bool {
	return true
}

// IsCode returns true when this get replication scale plan not implemented response a status code equal to that given
func (o *GetReplicationScalePlanNotImplemented) IsCode(code int) bool {
	return code == 501
}

// Code gets the status code for the get replication scale plan not implemented response
func (o *GetReplicationScalePlanNotImplemented) Code() int {
	return 501
}

func (o *GetReplicationScalePlanNotImplemented) Error() string {
	return fmt.Sprintf("[GET /replication/scale][%d] getReplicationScalePlanNotImplemented  %+v", 501, o.Payload)
}

func (o *GetReplicationScalePlanNotImplemented) String() string {
	return fmt.Sprintf("[GET /replication/scale][%d] getReplicationScalePlanNotImplemented  %+v", 501, o.Payload)
}

func (o *GetReplicationScalePlanNotImplemented) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GetReplicationScalePlanNotImplemented) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
