//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package replication

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewListReplicationParams creates a new ListReplicationParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewListReplicationParams() *ListReplicationParams {
	return &ListReplicationParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewListReplicationParamsWithTimeout creates a new ListReplicationParams object
// with the ability to set a timeout on a request.
func NewListReplicationParamsWithTimeout(timeout time.Duration) *ListReplicationParams {
	return &ListReplicationParams{
		timeout: timeout,
	}
}

// NewListReplicationParamsWithContext creates a new ListReplicationParams object
// with the ability to set a context for a request.
func NewListReplicationParamsWithContext(ctx context.Context) *ListReplicationParams {
	return &ListReplicationParams{
		Context: ctx,
	}
}

// NewListReplicationParamsWithHTTPClient creates a new ListReplicationParams object
// with the ability to set a custom HTTPClient for a request.
func NewListReplicationParamsWithHTTPClient(client *http.Client) *ListReplicationParams {
	return &ListReplicationParams{
		HTTPClient: client,
	}
}

/*
ListReplicationParams contains all the parameters to send to the API endpoint

	for the list replication operation.

	Typically these are written to a http.Request.
*/
type ListReplicationParams struct {

	/* Collection.

	   The name of the collection to get details for.
	*/
	Collection *string

	/* IncludeHistory.

	   Whether to include the history of the replication operation.
	*/
	IncludeHistory *bool

	/* Shard.

	   The shard to get details for.
	*/
	Shard *string

	/* TargetNode.

	   The name of the target node to get details for.
	*/
	TargetNode *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the list replication params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListReplicationParams) WithDefaults() *ListReplicationParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the list replication params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListReplicationParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the list replication params
func (o *ListReplicationParams) WithTimeout(timeout time.Duration) *ListReplicationParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the list replication params
func (o *ListReplicationParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the list replication params
func (o *ListReplicationParams) WithContext(ctx context.Context) *ListReplicationParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the list replication params
func (o *ListReplicationParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the list replication params
func (o *ListReplicationParams) WithHTTPClient(client *http.Client) *ListReplicationParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the list replication params
func (o *ListReplicationParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCollection adds the collection to the list replication params
func (o *ListReplicationParams) WithCollection(collection *string) *ListReplicationParams {
	o.SetCollection(collection)
	return o
}

// SetCollection adds the collection to the list replication params
func (o *ListReplicationParams) SetCollection(collection *string) {
	o.Collection = collection
}

// WithIncludeHistory adds the includeHistory to the list replication params
func (o *ListReplicationParams) WithIncludeHistory(includeHistory *bool) *ListReplicationParams {
	o.SetIncludeHistory(includeHistory)
	return o
}

// SetIncludeHistory adds the includeHistory to the list replication params
func (o *ListReplicationParams) SetIncludeHistory(includeHistory *bool) {
	o.IncludeHistory = includeHistory
}

// WithShard adds the shard to the list replication params
func (o *ListReplicationParams) WithShard(shard *string) *ListReplicationParams {
	o.SetShard(shard)
	return o
}

// SetShard adds the shard to the list replication params
func (o *ListReplicationParams) SetShard(shard *string) {
	o.Shard = shard
}

// WithTargetNode adds the targetNode to the list replication params
func (o *ListReplicationParams) WithTargetNode(targetNode *string) *ListReplicationParams {
	o.SetTargetNode(targetNode)
	return o
}

// SetTargetNode adds the targetNode to the list replication params
func (o *ListReplicationParams) SetTargetNode(targetNode *string) {
	o.TargetNode = targetNode
}

// WriteToRequest writes these params to a swagger request
func (o *ListReplicationParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Collection != nil {

		// query param collection
		var qrCollection string

		if o.Collection != nil {
			qrCollection = *o.Collection
		}
		qCollection := qrCollection
		if qCollection != "" {

			if err := r.SetQueryParam("collection", qCollection); err != nil {
				return err
			}
		}
	}

	if o.IncludeHistory != nil {

		// query param includeHistory
		var qrIncludeHistory bool

		if o.IncludeHistory != nil {
			qrIncludeHistory = *o.IncludeHistory
		}
		qIncludeHistory := swag.FormatBool(qrIncludeHistory)
		if qIncludeHistory != "" {

			if err := r.SetQueryParam("includeHistory", qIncludeHistory); err != nil {
				return err
			}
		}
	}

	if o.Shard != nil {

		// query param shard
		var qrShard string

		if o.Shard != nil {
			qrShard = *o.Shard
		}
		qShard := qrShard
		if qShard != "" {

			if err := r.SetQueryParam("shard", qShard); err != nil {
				return err
			}
		}
	}

	if o.TargetNode != nil {

		// query param targetNode
		var qrTargetNode string

		if o.TargetNode != nil {
			qrTargetNode = *o.TargetNode
		}
		qTargetNode := qrTargetNode
		if qTargetNode != "" {

			if err := r.SetQueryParam("targetNode", qTargetNode); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
