//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package replication

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// NewReplicateParams creates a new ReplicateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewReplicateParams() *ReplicateParams {
	return &ReplicateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewReplicateParamsWithTimeout creates a new ReplicateParams object
// with the ability to set a timeout on a request.
func NewReplicateParamsWithTimeout(timeout time.Duration) *ReplicateParams {
	return &ReplicateParams{
		timeout: timeout,
	}
}

// NewReplicateParamsWithContext creates a new ReplicateParams object
// with the ability to set a context for a request.
func NewReplicateParamsWithContext(ctx context.Context) *ReplicateParams {
	return &ReplicateParams{
		Context: ctx,
	}
}

// NewReplicateParamsWithHTTPClient creates a new ReplicateParams object
// with the ability to set a custom HTTPClient for a request.
func NewReplicateParamsWithHTTPClient(client *http.Client) *ReplicateParams {
	return &ReplicateParams{
		HTTPClient: client,
	}
}

/*
ReplicateParams contains all the parameters to send to the API endpoint

	for the replicate operation.

	Typically these are written to a http.Request.
*/
type ReplicateParams struct {

	// Body.
	Body *models.ReplicationReplicateReplicaRequest

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the replicate params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ReplicateParams) WithDefaults() *ReplicateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the replicate params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ReplicateParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the replicate params
func (o *ReplicateParams) WithTimeout(timeout time.Duration) *ReplicateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the replicate params
func (o *ReplicateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the replicate params
func (o *ReplicateParams) WithContext(ctx context.Context) *ReplicateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the replicate params
func (o *ReplicateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the replicate params
func (o *ReplicateParams) WithHTTPClient(client *http.Client) *ReplicateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the replicate params
func (o *ReplicateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the replicate params
func (o *ReplicateParams) WithBody(body *models.ReplicationReplicateReplicaRequest) *ReplicateParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the replicate params
func (o *ReplicateParams) SetBody(body *models.ReplicationReplicateReplicaRequest) {
	o.Body = body
}

// WriteToRequest writes these params to a swagger request
func (o *ReplicateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
