//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package replication

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// ReplicateReader is a Reader for the Replicate structure.
type ReplicateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ReplicateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewReplicateOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewReplicateBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewReplicateUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewReplicateForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 422:
		result := NewReplicateUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewReplicateInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 501:
		result := NewReplicateNotImplemented()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewReplicateOK creates a ReplicateOK with default headers values
func NewReplicateOK() *ReplicateOK {
	return &ReplicateOK{}
}

/*
ReplicateOK describes a response with status code 200, with default header values.

Replication operation registered successfully. ID of the operation is returned.
*/
type ReplicateOK struct {
	Payload *models.ReplicationReplicateReplicaResponse
}

// IsSuccess returns true when this replicate o k response has a 2xx status code
func (o *ReplicateOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this replicate o k response has a 3xx status code
func (o *ReplicateOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this replicate o k response has a 4xx status code
func (o *ReplicateOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this replicate o k response has a 5xx status code
func (o *ReplicateOK) IsServerError() bool {
	return false
}

// IsCode returns true when this replicate o k response a status code equal to that given
func (o *ReplicateOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the replicate o k response
func (o *ReplicateOK) Code() int {
	return 200
}

func (o *ReplicateOK) Error() string {
	return fmt.Sprintf("[POST /replication/replicate][%d] replicateOK  %+v", 200, o.Payload)
}

func (o *ReplicateOK) String() string {
	return fmt.Sprintf("[POST /replication/replicate][%d] replicateOK  %+v", 200, o.Payload)
}

func (o *ReplicateOK) GetPayload() *models.ReplicationReplicateReplicaResponse {
	return o.Payload
}

func (o *ReplicateOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ReplicationReplicateReplicaResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewReplicateBadRequest creates a ReplicateBadRequest with default headers values
func NewReplicateBadRequest() *ReplicateBadRequest {
	return &ReplicateBadRequest{}
}

/*
ReplicateBadRequest describes a response with status code 400, with default header values.

Malformed request.
*/
type ReplicateBadRequest struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this replicate bad request response has a 2xx status code
func (o *ReplicateBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this replicate bad request response has a 3xx status code
func (o *ReplicateBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this replicate bad request response has a 4xx status code
func (o *ReplicateBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this replicate bad request response has a 5xx status code
func (o *ReplicateBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this replicate bad request response a status code equal to that given
func (o *ReplicateBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the replicate bad request response
func (o *ReplicateBadRequest) Code() int {
	return 400
}

func (o *ReplicateBadRequest) Error() string {
	return fmt.Sprintf("[POST /replication/replicate][%d] replicateBadRequest  %+v", 400, o.Payload)
}

func (o *ReplicateBadRequest) String() string {
	return fmt.Sprintf("[POST /replication/replicate][%d] replicateBadRequest  %+v", 400, o.Payload)
}

func (o *ReplicateBadRequest) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ReplicateBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewReplicateUnauthorized creates a ReplicateUnauthorized with default headers values
func NewReplicateUnauthorized() *ReplicateUnauthorized {
	return &ReplicateUnauthorized{}
}

/*
ReplicateUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type ReplicateUnauthorized struct {
}

// IsSuccess returns true when this replicate unauthorized response has a 2xx status code
func (o *ReplicateUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this replicate unauthorized response has a 3xx status code
func (o *ReplicateUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this replicate unauthorized response has a 4xx status code
func (o *ReplicateUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this replicate unauthorized response has a 5xx status code
func (o *ReplicateUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this replicate unauthorized response a status code equal to that given
func (o *ReplicateUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the replicate unauthorized response
func (o *ReplicateUnauthorized) Code() int {
	return 401
}

func (o *ReplicateUnauthorized) Error() string {
	return fmt.Sprintf("[POST /replication/replicate][%d] replicateUnauthorized ", 401)
}

func (o *ReplicateUnauthorized) String() string {
	return fmt.Sprintf("[POST /replication/replicate][%d] replicateUnauthorized ", 401)
}

func (o *ReplicateUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewReplicateForbidden creates a ReplicateForbidden with default headers values
func NewReplicateForbidden() *ReplicateForbidden {
	return &ReplicateForbidden{}
}

/*
ReplicateForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type ReplicateForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this replicate forbidden response has a 2xx status code
func (o *ReplicateForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this replicate forbidden response has a 3xx status code
func (o *ReplicateForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this replicate forbidden response has a 4xx status code
func (o *ReplicateForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this replicate forbidden response has a 5xx status code
func (o *ReplicateForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this replicate forbidden response a status code equal to that given
func (o *ReplicateForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the replicate forbidden response
func (o *ReplicateForbidden) Code() int {
	return 403
}

func (o *ReplicateForbidden) Error() string {
	return fmt.Sprintf("[POST /replication/replicate][%d] replicateForbidden  %+v", 403, o.Payload)
}

func (o *ReplicateForbidden) String() string {
	return fmt.Sprintf("[POST /replication/replicate][%d] replicateForbidden  %+v", 403, o.Payload)
}

func (o *ReplicateForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ReplicateForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewReplicateUnprocessableEntity creates a ReplicateUnprocessableEntity with default headers values
func NewReplicateUnprocessableEntity() *ReplicateUnprocessableEntity {
	return &ReplicateUnprocessableEntity{}
}

/*
ReplicateUnprocessableEntity describes a response with status code 422, with default header values.

The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.
*/
type ReplicateUnprocessableEntity struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this replicate unprocessable entity response has a 2xx status code
func (o *ReplicateUnprocessableEntity) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this replicate unprocessable entity response has a 3xx status code
func (o *ReplicateUnprocessableEntity) IsRedirect() bool {
	return false
}

// IsClientError returns true when this replicate unprocessable entity response has a 4xx status code
func (o *ReplicateUnprocessableEntity) IsClientError() bool {
	return true
}

// IsServerError returns true when this replicate unprocessable entity response has a 5xx status code
func (o *ReplicateUnprocessableEntity) IsServerError() bool {
	return false
}

// IsCode returns true when this replicate unprocessable entity response a status code equal to that given
func (o *ReplicateUnprocessableEntity) IsCode(code int) bool {
	return code == 422
}

// Code gets the status code for the replicate unprocessable entity response
func (o *ReplicateUnprocessableEntity) Code() int {
	return 422
}

func (o *ReplicateUnprocessableEntity) Error() string {
	return fmt.Sprintf("[POST /replication/replicate][%d] replicateUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *ReplicateUnprocessableEntity) String() string {
	return fmt.Sprintf("[POST /replication/replicate][%d] replicateUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *ReplicateUnprocessableEntity) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ReplicateUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewReplicateInternalServerError creates a ReplicateInternalServerError with default headers values
func NewReplicateInternalServerError() *ReplicateInternalServerError {
	return &ReplicateInternalServerError{}
}

/*
ReplicateInternalServerError describes a response with status code 500, with default header values.

An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.
*/
type ReplicateInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this replicate internal server error response has a 2xx status code
func (o *ReplicateInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this replicate internal server error response has a 3xx status code
func (o *ReplicateInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this replicate internal server error response has a 4xx status code
func (o *ReplicateInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this replicate internal server error response has a 5xx status code
func (o *ReplicateInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this replicate internal server error response a status code equal to that given
func (o *ReplicateInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the replicate internal server error response
func (o *ReplicateInternalServerError) Code() int {
	return 500
}

func (o *ReplicateInternalServerError) Error() string {
	return fmt.Sprintf("[POST /replication/replicate][%d] replicateInternalServerError  %+v", 500, o.Payload)
}

func (o *ReplicateInternalServerError) String() string {
	return fmt.Sprintf("[POST /replication/replicate][%d] replicateInternalServerError  %+v", 500, o.Payload)
}

func (o *ReplicateInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ReplicateInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewReplicateNotImplemented creates a ReplicateNotImplemented with default headers values
func NewReplicateNotImplemented() *ReplicateNotImplemented {
	return &ReplicateNotImplemented{}
}

/*
ReplicateNotImplemented describes a response with status code 501, with default header values.

Replica movement operations are disabled.
*/
type ReplicateNotImplemented struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this replicate not implemented response has a 2xx status code
func (o *ReplicateNotImplemented) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this replicate not implemented response has a 3xx status code
func (o *ReplicateNotImplemented) IsRedirect() bool {
	return false
}

// IsClientError returns true when this replicate not implemented response has a 4xx status code
func (o *ReplicateNotImplemented) IsClientError() bool {
	return false
}

// IsServerError returns true when this replicate not implemented response has a 5xx status code
func (o *ReplicateNotImplemented) IsServerError() bool {
	return true
}

// IsCode returns true when this replicate not implemented response a status code equal to that given
func (o *ReplicateNotImplemented) IsCode(code int) bool {
	return code == 501
}

// Code gets the status code for the replicate not implemented response
func (o *ReplicateNotImplemented) Code() int {
	return 501
}

func (o *ReplicateNotImplemented) Error() string {
	return fmt.Sprintf("[POST /replication/replicate][%d] replicateNotImplemented  %+v", 501, o.Payload)
}

func (o *ReplicateNotImplemented) String() string {
	return fmt.Sprintf("[POST /replication/replicate][%d] replicateNotImplemented  %+v", 501, o.Payload)
}

func (o *ReplicateNotImplemented) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ReplicateNotImplemented) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
