//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package replication

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewReplicationDetailsParams creates a new ReplicationDetailsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewReplicationDetailsParams() *ReplicationDetailsParams {
	return &ReplicationDetailsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewReplicationDetailsParamsWithTimeout creates a new ReplicationDetailsParams object
// with the ability to set a timeout on a request.
func NewReplicationDetailsParamsWithTimeout(timeout time.Duration) *ReplicationDetailsParams {
	return &ReplicationDetailsParams{
		timeout: timeout,
	}
}

// NewReplicationDetailsParamsWithContext creates a new ReplicationDetailsParams object
// with the ability to set a context for a request.
func NewReplicationDetailsParamsWithContext(ctx context.Context) *ReplicationDetailsParams {
	return &ReplicationDetailsParams{
		Context: ctx,
	}
}

// NewReplicationDetailsParamsWithHTTPClient creates a new ReplicationDetailsParams object
// with the ability to set a custom HTTPClient for a request.
func NewReplicationDetailsParamsWithHTTPClient(client *http.Client) *ReplicationDetailsParams {
	return &ReplicationDetailsParams{
		HTTPClient: client,
	}
}

/*
ReplicationDetailsParams contains all the parameters to send to the API endpoint

	for the replication details operation.

	Typically these are written to a http.Request.
*/
type ReplicationDetailsParams struct {

	/* ID.

	   The ID of the replication operation to get details for.

	   Format: uuid
	*/
	ID strfmt.UUID

	/* IncludeHistory.

	   Whether to include the history of the replication operation.
	*/
	IncludeHistory *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the replication details params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ReplicationDetailsParams) WithDefaults() *ReplicationDetailsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the replication details params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ReplicationDetailsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the replication details params
func (o *ReplicationDetailsParams) WithTimeout(timeout time.Duration) *ReplicationDetailsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the replication details params
func (o *ReplicationDetailsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the replication details params
func (o *ReplicationDetailsParams) WithContext(ctx context.Context) *ReplicationDetailsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the replication details params
func (o *ReplicationDetailsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the replication details params
func (o *ReplicationDetailsParams) WithHTTPClient(client *http.Client) *ReplicationDetailsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the replication details params
func (o *ReplicationDetailsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithID adds the id to the replication details params
func (o *ReplicationDetailsParams) WithID(id strfmt.UUID) *ReplicationDetailsParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the replication details params
func (o *ReplicationDetailsParams) SetID(id strfmt.UUID) {
	o.ID = id
}

// WithIncludeHistory adds the includeHistory to the replication details params
func (o *ReplicationDetailsParams) WithIncludeHistory(includeHistory *bool) *ReplicationDetailsParams {
	o.SetIncludeHistory(includeHistory)
	return o
}

// SetIncludeHistory adds the includeHistory to the replication details params
func (o *ReplicationDetailsParams) SetIncludeHistory(includeHistory *bool) {
	o.IncludeHistory = includeHistory
}

// WriteToRequest writes these params to a swagger request
func (o *ReplicationDetailsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param id
	if err := r.SetPathParam("id", o.ID.String()); err != nil {
		return err
	}

	if o.IncludeHistory != nil {

		// query param includeHistory
		var qrIncludeHistory bool

		if o.IncludeHistory != nil {
			qrIncludeHistory = *o.IncludeHistory
		}
		qIncludeHistory := swag.FormatBool(qrIncludeHistory)
		if qIncludeHistory != "" {

			if err := r.SetQueryParam("includeHistory", qIncludeHistory); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
