//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// NewAliasesCreateParams creates a new AliasesCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAliasesCreateParams() *AliasesCreateParams {
	return &AliasesCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAliasesCreateParamsWithTimeout creates a new AliasesCreateParams object
// with the ability to set a timeout on a request.
func NewAliasesCreateParamsWithTimeout(timeout time.Duration) *AliasesCreateParams {
	return &AliasesCreateParams{
		timeout: timeout,
	}
}

// NewAliasesCreateParamsWithContext creates a new AliasesCreateParams object
// with the ability to set a context for a request.
func NewAliasesCreateParamsWithContext(ctx context.Context) *AliasesCreateParams {
	return &AliasesCreateParams{
		Context: ctx,
	}
}

// NewAliasesCreateParamsWithHTTPClient creates a new AliasesCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewAliasesCreateParamsWithHTTPClient(client *http.Client) *AliasesCreateParams {
	return &AliasesCreateParams{
		HTTPClient: client,
	}
}

/*
AliasesCreateParams contains all the parameters to send to the API endpoint

	for the aliases create operation.

	Typically these are written to a http.Request.
*/
type AliasesCreateParams struct {

	// Body.
	Body *models.Alias

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the aliases create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AliasesCreateParams) WithDefaults() *AliasesCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the aliases create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AliasesCreateParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the aliases create params
func (o *AliasesCreateParams) WithTimeout(timeout time.Duration) *AliasesCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the aliases create params
func (o *AliasesCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the aliases create params
func (o *AliasesCreateParams) WithContext(ctx context.Context) *AliasesCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the aliases create params
func (o *AliasesCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the aliases create params
func (o *AliasesCreateParams) WithHTTPClient(client *http.Client) *AliasesCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the aliases create params
func (o *AliasesCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the aliases create params
func (o *AliasesCreateParams) WithBody(body *models.Alias) *AliasesCreateParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the aliases create params
func (o *AliasesCreateParams) SetBody(body *models.Alias) {
	o.Body = body
}

// WriteToRequest writes these params to a swagger request
func (o *AliasesCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
