//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewAliasesGetAliasParams creates a new AliasesGetAliasParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAliasesGetAliasParams() *AliasesGetAliasParams {
	return &AliasesGetAliasParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAliasesGetAliasParamsWithTimeout creates a new AliasesGetAliasParams object
// with the ability to set a timeout on a request.
func NewAliasesGetAliasParamsWithTimeout(timeout time.Duration) *AliasesGetAliasParams {
	return &AliasesGetAliasParams{
		timeout: timeout,
	}
}

// NewAliasesGetAliasParamsWithContext creates a new AliasesGetAliasParams object
// with the ability to set a context for a request.
func NewAliasesGetAliasParamsWithContext(ctx context.Context) *AliasesGetAliasParams {
	return &AliasesGetAliasParams{
		Context: ctx,
	}
}

// NewAliasesGetAliasParamsWithHTTPClient creates a new AliasesGetAliasParams object
// with the ability to set a custom HTTPClient for a request.
func NewAliasesGetAliasParamsWithHTTPClient(client *http.Client) *AliasesGetAliasParams {
	return &AliasesGetAliasParams{
		HTTPClient: client,
	}
}

/*
AliasesGetAliasParams contains all the parameters to send to the API endpoint

	for the aliases get alias operation.

	Typically these are written to a http.Request.
*/
type AliasesGetAliasParams struct {

	// AliasName.
	AliasName string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the aliases get alias params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AliasesGetAliasParams) WithDefaults() *AliasesGetAliasParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the aliases get alias params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AliasesGetAliasParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the aliases get alias params
func (o *AliasesGetAliasParams) WithTimeout(timeout time.Duration) *AliasesGetAliasParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the aliases get alias params
func (o *AliasesGetAliasParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the aliases get alias params
func (o *AliasesGetAliasParams) WithContext(ctx context.Context) *AliasesGetAliasParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the aliases get alias params
func (o *AliasesGetAliasParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the aliases get alias params
func (o *AliasesGetAliasParams) WithHTTPClient(client *http.Client) *AliasesGetAliasParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the aliases get alias params
func (o *AliasesGetAliasParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAliasName adds the aliasName to the aliases get alias params
func (o *AliasesGetAliasParams) WithAliasName(aliasName string) *AliasesGetAliasParams {
	o.SetAliasName(aliasName)
	return o
}

// SetAliasName adds the aliasName to the aliases get alias params
func (o *AliasesGetAliasParams) SetAliasName(aliasName string) {
	o.AliasName = aliasName
}

// WriteToRequest writes these params to a swagger request
func (o *AliasesGetAliasParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param aliasName
	if err := r.SetPathParam("aliasName", o.AliasName); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
