//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/weaviate/weaviate/entities/models"
)

// AliasesUpdateReader is a Reader for the AliasesUpdate structure.
type AliasesUpdateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AliasesUpdateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAliasesUpdateOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewAliasesUpdateUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewAliasesUpdateForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewAliasesUpdateNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 422:
		result := NewAliasesUpdateUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewAliasesUpdateInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewAliasesUpdateOK creates a AliasesUpdateOK with default headers values
func NewAliasesUpdateOK() *AliasesUpdateOK {
	return &AliasesUpdateOK{}
}

/*
AliasesUpdateOK describes a response with status code 200, with default header values.

Successfully updated the alias to point to the new collection (class).
*/
type AliasesUpdateOK struct {
	Payload *models.Alias
}

// IsSuccess returns true when this aliases update o k response has a 2xx status code
func (o *AliasesUpdateOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this aliases update o k response has a 3xx status code
func (o *AliasesUpdateOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aliases update o k response has a 4xx status code
func (o *AliasesUpdateOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this aliases update o k response has a 5xx status code
func (o *AliasesUpdateOK) IsServerError() bool {
	return false
}

// IsCode returns true when this aliases update o k response a status code equal to that given
func (o *AliasesUpdateOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the aliases update o k response
func (o *AliasesUpdateOK) Code() int {
	return 200
}

func (o *AliasesUpdateOK) Error() string {
	return fmt.Sprintf("[PUT /aliases/{aliasName}][%d] aliasesUpdateOK  %+v", 200, o.Payload)
}

func (o *AliasesUpdateOK) String() string {
	return fmt.Sprintf("[PUT /aliases/{aliasName}][%d] aliasesUpdateOK  %+v", 200, o.Payload)
}

func (o *AliasesUpdateOK) GetPayload() *models.Alias {
	return o.Payload
}

func (o *AliasesUpdateOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Alias)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAliasesUpdateUnauthorized creates a AliasesUpdateUnauthorized with default headers values
func NewAliasesUpdateUnauthorized() *AliasesUpdateUnauthorized {
	return &AliasesUpdateUnauthorized{}
}

/*
AliasesUpdateUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type AliasesUpdateUnauthorized struct {
}

// IsSuccess returns true when this aliases update unauthorized response has a 2xx status code
func (o *AliasesUpdateUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this aliases update unauthorized response has a 3xx status code
func (o *AliasesUpdateUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aliases update unauthorized response has a 4xx status code
func (o *AliasesUpdateUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this aliases update unauthorized response has a 5xx status code
func (o *AliasesUpdateUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this aliases update unauthorized response a status code equal to that given
func (o *AliasesUpdateUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the aliases update unauthorized response
func (o *AliasesUpdateUnauthorized) Code() int {
	return 401
}

func (o *AliasesUpdateUnauthorized) Error() string {
	return fmt.Sprintf("[PUT /aliases/{aliasName}][%d] aliasesUpdateUnauthorized ", 401)
}

func (o *AliasesUpdateUnauthorized) String() string {
	return fmt.Sprintf("[PUT /aliases/{aliasName}][%d] aliasesUpdateUnauthorized ", 401)
}

func (o *AliasesUpdateUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewAliasesUpdateForbidden creates a AliasesUpdateForbidden with default headers values
func NewAliasesUpdateForbidden() *AliasesUpdateForbidden {
	return &AliasesUpdateForbidden{}
}

/*
AliasesUpdateForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type AliasesUpdateForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this aliases update forbidden response has a 2xx status code
func (o *AliasesUpdateForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this aliases update forbidden response has a 3xx status code
func (o *AliasesUpdateForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aliases update forbidden response has a 4xx status code
func (o *AliasesUpdateForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this aliases update forbidden response has a 5xx status code
func (o *AliasesUpdateForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this aliases update forbidden response a status code equal to that given
func (o *AliasesUpdateForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the aliases update forbidden response
func (o *AliasesUpdateForbidden) Code() int {
	return 403
}

func (o *AliasesUpdateForbidden) Error() string {
	return fmt.Sprintf("[PUT /aliases/{aliasName}][%d] aliasesUpdateForbidden  %+v", 403, o.Payload)
}

func (o *AliasesUpdateForbidden) String() string {
	return fmt.Sprintf("[PUT /aliases/{aliasName}][%d] aliasesUpdateForbidden  %+v", 403, o.Payload)
}

func (o *AliasesUpdateForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AliasesUpdateForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAliasesUpdateNotFound creates a AliasesUpdateNotFound with default headers values
func NewAliasesUpdateNotFound() *AliasesUpdateNotFound {
	return &AliasesUpdateNotFound{}
}

/*
AliasesUpdateNotFound describes a response with status code 404, with default header values.

Not Found - Alias does not exist
*/
type AliasesUpdateNotFound struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this aliases update not found response has a 2xx status code
func (o *AliasesUpdateNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this aliases update not found response has a 3xx status code
func (o *AliasesUpdateNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aliases update not found response has a 4xx status code
func (o *AliasesUpdateNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this aliases update not found response has a 5xx status code
func (o *AliasesUpdateNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this aliases update not found response a status code equal to that given
func (o *AliasesUpdateNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the aliases update not found response
func (o *AliasesUpdateNotFound) Code() int {
	return 404
}

func (o *AliasesUpdateNotFound) Error() string {
	return fmt.Sprintf("[PUT /aliases/{aliasName}][%d] aliasesUpdateNotFound  %+v", 404, o.Payload)
}

func (o *AliasesUpdateNotFound) String() string {
	return fmt.Sprintf("[PUT /aliases/{aliasName}][%d] aliasesUpdateNotFound  %+v", 404, o.Payload)
}

func (o *AliasesUpdateNotFound) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AliasesUpdateNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAliasesUpdateUnprocessableEntity creates a AliasesUpdateUnprocessableEntity with default headers values
func NewAliasesUpdateUnprocessableEntity() *AliasesUpdateUnprocessableEntity {
	return &AliasesUpdateUnprocessableEntity{}
}

/*
AliasesUpdateUnprocessableEntity describes a response with status code 422, with default header values.

Invalid update alias request.
*/
type AliasesUpdateUnprocessableEntity struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this aliases update unprocessable entity response has a 2xx status code
func (o *AliasesUpdateUnprocessableEntity) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this aliases update unprocessable entity response has a 3xx status code
func (o *AliasesUpdateUnprocessableEntity) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aliases update unprocessable entity response has a 4xx status code
func (o *AliasesUpdateUnprocessableEntity) IsClientError() bool {
	return true
}

// IsServerError returns true when this aliases update unprocessable entity response has a 5xx status code
func (o *AliasesUpdateUnprocessableEntity) IsServerError() bool {
	return false
}

// IsCode returns true when this aliases update unprocessable entity response a status code equal to that given
func (o *AliasesUpdateUnprocessableEntity) IsCode(code int) bool {
	return code == 422
}

// Code gets the status code for the aliases update unprocessable entity response
func (o *AliasesUpdateUnprocessableEntity) Code() int {
	return 422
}

func (o *AliasesUpdateUnprocessableEntity) Error() string {
	return fmt.Sprintf("[PUT /aliases/{aliasName}][%d] aliasesUpdateUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *AliasesUpdateUnprocessableEntity) String() string {
	return fmt.Sprintf("[PUT /aliases/{aliasName}][%d] aliasesUpdateUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *AliasesUpdateUnprocessableEntity) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AliasesUpdateUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAliasesUpdateInternalServerError creates a AliasesUpdateInternalServerError with default headers values
func NewAliasesUpdateInternalServerError() *AliasesUpdateInternalServerError {
	return &AliasesUpdateInternalServerError{}
}

/*
AliasesUpdateInternalServerError describes a response with status code 500, with default header values.

An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.
*/
type AliasesUpdateInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this aliases update internal server error response has a 2xx status code
func (o *AliasesUpdateInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this aliases update internal server error response has a 3xx status code
func (o *AliasesUpdateInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aliases update internal server error response has a 4xx status code
func (o *AliasesUpdateInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this aliases update internal server error response has a 5xx status code
func (o *AliasesUpdateInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this aliases update internal server error response a status code equal to that given
func (o *AliasesUpdateInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the aliases update internal server error response
func (o *AliasesUpdateInternalServerError) Code() int {
	return 500
}

func (o *AliasesUpdateInternalServerError) Error() string {
	return fmt.Sprintf("[PUT /aliases/{aliasName}][%d] aliasesUpdateInternalServerError  %+v", 500, o.Payload)
}

func (o *AliasesUpdateInternalServerError) String() string {
	return fmt.Sprintf("[PUT /aliases/{aliasName}][%d] aliasesUpdateInternalServerError  %+v", 500, o.Payload)
}

func (o *AliasesUpdateInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AliasesUpdateInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
AliasesUpdateBody aliases update body
swagger:model AliasesUpdateBody
*/
type AliasesUpdateBody struct {

	// The new collection (class) that the alias should point to.
	Class string `json:"class,omitempty"`
}

// Validate validates this aliases update body
func (o *AliasesUpdateBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this aliases update body based on context it is used
func (o *AliasesUpdateBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *AliasesUpdateBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AliasesUpdateBody) UnmarshalBinary(b []byte) error {
	var res AliasesUpdateBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
