//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// TenantsDeleteReader is a Reader for the TenantsDelete structure.
type TenantsDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *TenantsDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewTenantsDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewTenantsDeleteUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewTenantsDeleteForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 422:
		result := NewTenantsDeleteUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewTenantsDeleteInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewTenantsDeleteOK creates a TenantsDeleteOK with default headers values
func NewTenantsDeleteOK() *TenantsDeleteOK {
	return &TenantsDeleteOK{}
}

/*
TenantsDeleteOK describes a response with status code 200, with default header values.

Tenants deleted successfully.
*/
type TenantsDeleteOK struct {
}

// IsSuccess returns true when this tenants delete o k response has a 2xx status code
func (o *TenantsDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this tenants delete o k response has a 3xx status code
func (o *TenantsDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this tenants delete o k response has a 4xx status code
func (o *TenantsDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this tenants delete o k response has a 5xx status code
func (o *TenantsDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this tenants delete o k response a status code equal to that given
func (o *TenantsDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the tenants delete o k response
func (o *TenantsDeleteOK) Code() int {
	return 200
}

func (o *TenantsDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /schema/{className}/tenants][%d] tenantsDeleteOK ", 200)
}

func (o *TenantsDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /schema/{className}/tenants][%d] tenantsDeleteOK ", 200)
}

func (o *TenantsDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewTenantsDeleteUnauthorized creates a TenantsDeleteUnauthorized with default headers values
func NewTenantsDeleteUnauthorized() *TenantsDeleteUnauthorized {
	return &TenantsDeleteUnauthorized{}
}

/*
TenantsDeleteUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type TenantsDeleteUnauthorized struct {
}

// IsSuccess returns true when this tenants delete unauthorized response has a 2xx status code
func (o *TenantsDeleteUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this tenants delete unauthorized response has a 3xx status code
func (o *TenantsDeleteUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this tenants delete unauthorized response has a 4xx status code
func (o *TenantsDeleteUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this tenants delete unauthorized response has a 5xx status code
func (o *TenantsDeleteUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this tenants delete unauthorized response a status code equal to that given
func (o *TenantsDeleteUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the tenants delete unauthorized response
func (o *TenantsDeleteUnauthorized) Code() int {
	return 401
}

func (o *TenantsDeleteUnauthorized) Error() string {
	return fmt.Sprintf("[DELETE /schema/{className}/tenants][%d] tenantsDeleteUnauthorized ", 401)
}

func (o *TenantsDeleteUnauthorized) String() string {
	return fmt.Sprintf("[DELETE /schema/{className}/tenants][%d] tenantsDeleteUnauthorized ", 401)
}

func (o *TenantsDeleteUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewTenantsDeleteForbidden creates a TenantsDeleteForbidden with default headers values
func NewTenantsDeleteForbidden() *TenantsDeleteForbidden {
	return &TenantsDeleteForbidden{}
}

/*
TenantsDeleteForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type TenantsDeleteForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this tenants delete forbidden response has a 2xx status code
func (o *TenantsDeleteForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this tenants delete forbidden response has a 3xx status code
func (o *TenantsDeleteForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this tenants delete forbidden response has a 4xx status code
func (o *TenantsDeleteForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this tenants delete forbidden response has a 5xx status code
func (o *TenantsDeleteForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this tenants delete forbidden response a status code equal to that given
func (o *TenantsDeleteForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the tenants delete forbidden response
func (o *TenantsDeleteForbidden) Code() int {
	return 403
}

func (o *TenantsDeleteForbidden) Error() string {
	return fmt.Sprintf("[DELETE /schema/{className}/tenants][%d] tenantsDeleteForbidden  %+v", 403, o.Payload)
}

func (o *TenantsDeleteForbidden) String() string {
	return fmt.Sprintf("[DELETE /schema/{className}/tenants][%d] tenantsDeleteForbidden  %+v", 403, o.Payload)
}

func (o *TenantsDeleteForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *TenantsDeleteForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewTenantsDeleteUnprocessableEntity creates a TenantsDeleteUnprocessableEntity with default headers values
func NewTenantsDeleteUnprocessableEntity() *TenantsDeleteUnprocessableEntity {
	return &TenantsDeleteUnprocessableEntity{}
}

/*
TenantsDeleteUnprocessableEntity describes a response with status code 422, with default header values.

Invalid request.
*/
type TenantsDeleteUnprocessableEntity struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this tenants delete unprocessable entity response has a 2xx status code
func (o *TenantsDeleteUnprocessableEntity) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this tenants delete unprocessable entity response has a 3xx status code
func (o *TenantsDeleteUnprocessableEntity) IsRedirect() bool {
	return false
}

// IsClientError returns true when this tenants delete unprocessable entity response has a 4xx status code
func (o *TenantsDeleteUnprocessableEntity) IsClientError() bool {
	return true
}

// IsServerError returns true when this tenants delete unprocessable entity response has a 5xx status code
func (o *TenantsDeleteUnprocessableEntity) IsServerError() bool {
	return false
}

// IsCode returns true when this tenants delete unprocessable entity response a status code equal to that given
func (o *TenantsDeleteUnprocessableEntity) IsCode(code int) bool {
	return code == 422
}

// Code gets the status code for the tenants delete unprocessable entity response
func (o *TenantsDeleteUnprocessableEntity) Code() int {
	return 422
}

func (o *TenantsDeleteUnprocessableEntity) Error() string {
	return fmt.Sprintf("[DELETE /schema/{className}/tenants][%d] tenantsDeleteUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *TenantsDeleteUnprocessableEntity) String() string {
	return fmt.Sprintf("[DELETE /schema/{className}/tenants][%d] tenantsDeleteUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *TenantsDeleteUnprocessableEntity) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *TenantsDeleteUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewTenantsDeleteInternalServerError creates a TenantsDeleteInternalServerError with default headers values
func NewTenantsDeleteInternalServerError() *TenantsDeleteInternalServerError {
	return &TenantsDeleteInternalServerError{}
}

/*
TenantsDeleteInternalServerError describes a response with status code 500, with default header values.

An error occurred while deleting tenants. Check the ErrorResponse for details.
*/
type TenantsDeleteInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this tenants delete internal server error response has a 2xx status code
func (o *TenantsDeleteInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this tenants delete internal server error response has a 3xx status code
func (o *TenantsDeleteInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this tenants delete internal server error response has a 4xx status code
func (o *TenantsDeleteInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this tenants delete internal server error response has a 5xx status code
func (o *TenantsDeleteInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this tenants delete internal server error response a status code equal to that given
func (o *TenantsDeleteInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the tenants delete internal server error response
func (o *TenantsDeleteInternalServerError) Code() int {
	return 500
}

func (o *TenantsDeleteInternalServerError) Error() string {
	return fmt.Sprintf("[DELETE /schema/{className}/tenants][%d] tenantsDeleteInternalServerError  %+v", 500, o.Payload)
}

func (o *TenantsDeleteInternalServerError) String() string {
	return fmt.Sprintf("[DELETE /schema/{className}/tenants][%d] tenantsDeleteInternalServerError  %+v", 500, o.Payload)
}

func (o *TenantsDeleteInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *TenantsDeleteInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
