//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// TenantsGetReader is a Reader for the TenantsGet structure.
type TenantsGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *TenantsGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewTenantsGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewTenantsGetUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewTenantsGetForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 422:
		result := NewTenantsGetUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewTenantsGetInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewTenantsGetOK creates a TenantsGetOK with default headers values
func NewTenantsGetOK() *TenantsGetOK {
	return &TenantsGetOK{}
}

/*
TenantsGetOK describes a response with status code 200, with default header values.

Successfully retrieved tenants.
*/
type TenantsGetOK struct {
	Payload []*models.Tenant
}

// IsSuccess returns true when this tenants get o k response has a 2xx status code
func (o *TenantsGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this tenants get o k response has a 3xx status code
func (o *TenantsGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this tenants get o k response has a 4xx status code
func (o *TenantsGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this tenants get o k response has a 5xx status code
func (o *TenantsGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this tenants get o k response a status code equal to that given
func (o *TenantsGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the tenants get o k response
func (o *TenantsGetOK) Code() int {
	return 200
}

func (o *TenantsGetOK) Error() string {
	return fmt.Sprintf("[GET /schema/{className}/tenants][%d] tenantsGetOK  %+v", 200, o.Payload)
}

func (o *TenantsGetOK) String() string {
	return fmt.Sprintf("[GET /schema/{className}/tenants][%d] tenantsGetOK  %+v", 200, o.Payload)
}

func (o *TenantsGetOK) GetPayload() []*models.Tenant {
	return o.Payload
}

func (o *TenantsGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewTenantsGetUnauthorized creates a TenantsGetUnauthorized with default headers values
func NewTenantsGetUnauthorized() *TenantsGetUnauthorized {
	return &TenantsGetUnauthorized{}
}

/*
TenantsGetUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type TenantsGetUnauthorized struct {
}

// IsSuccess returns true when this tenants get unauthorized response has a 2xx status code
func (o *TenantsGetUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this tenants get unauthorized response has a 3xx status code
func (o *TenantsGetUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this tenants get unauthorized response has a 4xx status code
func (o *TenantsGetUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this tenants get unauthorized response has a 5xx status code
func (o *TenantsGetUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this tenants get unauthorized response a status code equal to that given
func (o *TenantsGetUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the tenants get unauthorized response
func (o *TenantsGetUnauthorized) Code() int {
	return 401
}

func (o *TenantsGetUnauthorized) Error() string {
	return fmt.Sprintf("[GET /schema/{className}/tenants][%d] tenantsGetUnauthorized ", 401)
}

func (o *TenantsGetUnauthorized) String() string {
	return fmt.Sprintf("[GET /schema/{className}/tenants][%d] tenantsGetUnauthorized ", 401)
}

func (o *TenantsGetUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewTenantsGetForbidden creates a TenantsGetForbidden with default headers values
func NewTenantsGetForbidden() *TenantsGetForbidden {
	return &TenantsGetForbidden{}
}

/*
TenantsGetForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type TenantsGetForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this tenants get forbidden response has a 2xx status code
func (o *TenantsGetForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this tenants get forbidden response has a 3xx status code
func (o *TenantsGetForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this tenants get forbidden response has a 4xx status code
func (o *TenantsGetForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this tenants get forbidden response has a 5xx status code
func (o *TenantsGetForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this tenants get forbidden response a status code equal to that given
func (o *TenantsGetForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the tenants get forbidden response
func (o *TenantsGetForbidden) Code() int {
	return 403
}

func (o *TenantsGetForbidden) Error() string {
	return fmt.Sprintf("[GET /schema/{className}/tenants][%d] tenantsGetForbidden  %+v", 403, o.Payload)
}

func (o *TenantsGetForbidden) String() string {
	return fmt.Sprintf("[GET /schema/{className}/tenants][%d] tenantsGetForbidden  %+v", 403, o.Payload)
}

func (o *TenantsGetForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *TenantsGetForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewTenantsGetUnprocessableEntity creates a TenantsGetUnprocessableEntity with default headers values
func NewTenantsGetUnprocessableEntity() *TenantsGetUnprocessableEntity {
	return &TenantsGetUnprocessableEntity{}
}

/*
TenantsGetUnprocessableEntity describes a response with status code 422, with default header values.

Invalid request.
*/
type TenantsGetUnprocessableEntity struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this tenants get unprocessable entity response has a 2xx status code
func (o *TenantsGetUnprocessableEntity) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this tenants get unprocessable entity response has a 3xx status code
func (o *TenantsGetUnprocessableEntity) IsRedirect() bool {
	return false
}

// IsClientError returns true when this tenants get unprocessable entity response has a 4xx status code
func (o *TenantsGetUnprocessableEntity) IsClientError() bool {
	return true
}

// IsServerError returns true when this tenants get unprocessable entity response has a 5xx status code
func (o *TenantsGetUnprocessableEntity) IsServerError() bool {
	return false
}

// IsCode returns true when this tenants get unprocessable entity response a status code equal to that given
func (o *TenantsGetUnprocessableEntity) IsCode(code int) bool {
	return code == 422
}

// Code gets the status code for the tenants get unprocessable entity response
func (o *TenantsGetUnprocessableEntity) Code() int {
	return 422
}

func (o *TenantsGetUnprocessableEntity) Error() string {
	return fmt.Sprintf("[GET /schema/{className}/tenants][%d] tenantsGetUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *TenantsGetUnprocessableEntity) String() string {
	return fmt.Sprintf("[GET /schema/{className}/tenants][%d] tenantsGetUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *TenantsGetUnprocessableEntity) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *TenantsGetUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewTenantsGetInternalServerError creates a TenantsGetInternalServerError with default headers values
func NewTenantsGetInternalServerError() *TenantsGetInternalServerError {
	return &TenantsGetInternalServerError{}
}

/*
TenantsGetInternalServerError describes a response with status code 500, with default header values.

An error occurred while listing tenants. Check the ErrorResponse for details.
*/
type TenantsGetInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this tenants get internal server error response has a 2xx status code
func (o *TenantsGetInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this tenants get internal server error response has a 3xx status code
func (o *TenantsGetInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this tenants get internal server error response has a 4xx status code
func (o *TenantsGetInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this tenants get internal server error response has a 5xx status code
func (o *TenantsGetInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this tenants get internal server error response a status code equal to that given
func (o *TenantsGetInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the tenants get internal server error response
func (o *TenantsGetInternalServerError) Code() int {
	return 500
}

func (o *TenantsGetInternalServerError) Error() string {
	return fmt.Sprintf("[GET /schema/{className}/tenants][%d] tenantsGetInternalServerError  %+v", 500, o.Payload)
}

func (o *TenantsGetInternalServerError) String() string {
	return fmt.Sprintf("[GET /schema/{className}/tenants][%d] tenantsGetInternalServerError  %+v", 500, o.Payload)
}

func (o *TenantsGetInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *TenantsGetInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
