//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// NewTenantsUpdateParams creates a new TenantsUpdateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewTenantsUpdateParams() *TenantsUpdateParams {
	return &TenantsUpdateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewTenantsUpdateParamsWithTimeout creates a new TenantsUpdateParams object
// with the ability to set a timeout on a request.
func NewTenantsUpdateParamsWithTimeout(timeout time.Duration) *TenantsUpdateParams {
	return &TenantsUpdateParams{
		timeout: timeout,
	}
}

// NewTenantsUpdateParamsWithContext creates a new TenantsUpdateParams object
// with the ability to set a context for a request.
func NewTenantsUpdateParamsWithContext(ctx context.Context) *TenantsUpdateParams {
	return &TenantsUpdateParams{
		Context: ctx,
	}
}

// NewTenantsUpdateParamsWithHTTPClient creates a new TenantsUpdateParams object
// with the ability to set a custom HTTPClient for a request.
func NewTenantsUpdateParamsWithHTTPClient(client *http.Client) *TenantsUpdateParams {
	return &TenantsUpdateParams{
		HTTPClient: client,
	}
}

/*
TenantsUpdateParams contains all the parameters to send to the API endpoint

	for the tenants update operation.

	Typically these are written to a http.Request.
*/
type TenantsUpdateParams struct {

	/* Body.

	   An array of tenant objects specifying the tenants to update and their desired new status.
	*/
	Body []*models.Tenant

	/* ClassName.

	   The name of the collection (class) containing the tenants.
	*/
	ClassName string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the tenants update params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *TenantsUpdateParams) WithDefaults() *TenantsUpdateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the tenants update params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *TenantsUpdateParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the tenants update params
func (o *TenantsUpdateParams) WithTimeout(timeout time.Duration) *TenantsUpdateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the tenants update params
func (o *TenantsUpdateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the tenants update params
func (o *TenantsUpdateParams) WithContext(ctx context.Context) *TenantsUpdateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the tenants update params
func (o *TenantsUpdateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the tenants update params
func (o *TenantsUpdateParams) WithHTTPClient(client *http.Client) *TenantsUpdateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the tenants update params
func (o *TenantsUpdateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the tenants update params
func (o *TenantsUpdateParams) WithBody(body []*models.Tenant) *TenantsUpdateParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the tenants update params
func (o *TenantsUpdateParams) SetBody(body []*models.Tenant) {
	o.Body = body
}

// WithClassName adds the className to the tenants update params
func (o *TenantsUpdateParams) WithClassName(className string) *TenantsUpdateParams {
	o.SetClassName(className)
	return o
}

// SetClassName adds the className to the tenants update params
func (o *TenantsUpdateParams) SetClassName(className string) {
	o.ClassName = className
}

// WriteToRequest writes these params to a swagger request
func (o *TenantsUpdateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param className
	if err := r.SetPathParam("className", o.ClassName); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
