//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package users

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewRotateUserAPIKeyParams creates a new RotateUserAPIKeyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewRotateUserAPIKeyParams() *RotateUserAPIKeyParams {
	return &RotateUserAPIKeyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewRotateUserAPIKeyParamsWithTimeout creates a new RotateUserAPIKeyParams object
// with the ability to set a timeout on a request.
func NewRotateUserAPIKeyParamsWithTimeout(timeout time.Duration) *RotateUserAPIKeyParams {
	return &RotateUserAPIKeyParams{
		timeout: timeout,
	}
}

// NewRotateUserAPIKeyParamsWithContext creates a new RotateUserAPIKeyParams object
// with the ability to set a context for a request.
func NewRotateUserAPIKeyParamsWithContext(ctx context.Context) *RotateUserAPIKeyParams {
	return &RotateUserAPIKeyParams{
		Context: ctx,
	}
}

// NewRotateUserAPIKeyParamsWithHTTPClient creates a new RotateUserAPIKeyParams object
// with the ability to set a custom HTTPClient for a request.
func NewRotateUserAPIKeyParamsWithHTTPClient(client *http.Client) *RotateUserAPIKeyParams {
	return &RotateUserAPIKeyParams{
		HTTPClient: client,
	}
}

/*
RotateUserAPIKeyParams contains all the parameters to send to the API endpoint

	for the rotate user Api key operation.

	Typically these are written to a http.Request.
*/
type RotateUserAPIKeyParams struct {

	/* UserID.

	   The name of the user.
	*/
	UserID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the rotate user Api key params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RotateUserAPIKeyParams) WithDefaults() *RotateUserAPIKeyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the rotate user Api key params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RotateUserAPIKeyParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the rotate user Api key params
func (o *RotateUserAPIKeyParams) WithTimeout(timeout time.Duration) *RotateUserAPIKeyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the rotate user Api key params
func (o *RotateUserAPIKeyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the rotate user Api key params
func (o *RotateUserAPIKeyParams) WithContext(ctx context.Context) *RotateUserAPIKeyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the rotate user Api key params
func (o *RotateUserAPIKeyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the rotate user Api key params
func (o *RotateUserAPIKeyParams) WithHTTPClient(client *http.Client) *RotateUserAPIKeyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the rotate user Api key params
func (o *RotateUserAPIKeyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithUserID adds the userID to the rotate user Api key params
func (o *RotateUserAPIKeyParams) WithUserID(userID string) *RotateUserAPIKeyParams {
	o.SetUserID(userID)
	return o
}

// SetUserID adds the userId to the rotate user Api key params
func (o *RotateUserAPIKeyParams) SetUserID(userID string) {
	o.UserID = userID
}

// WriteToRequest writes these params to a swagger request
func (o *RotateUserAPIKeyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param user_id
	if err := r.SetPathParam("user_id", o.UserID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
