//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package users

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// RotateUserAPIKeyReader is a Reader for the RotateUserAPIKey structure.
type RotateUserAPIKeyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *RotateUserAPIKeyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewRotateUserAPIKeyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewRotateUserAPIKeyBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewRotateUserAPIKeyUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewRotateUserAPIKeyForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewRotateUserAPIKeyNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 422:
		result := NewRotateUserAPIKeyUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewRotateUserAPIKeyInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewRotateUserAPIKeyOK creates a RotateUserAPIKeyOK with default headers values
func NewRotateUserAPIKeyOK() *RotateUserAPIKeyOK {
	return &RotateUserAPIKeyOK{}
}

/*
RotateUserAPIKeyOK describes a response with status code 200, with default header values.

API key successfully updated.
*/
type RotateUserAPIKeyOK struct {
	Payload *models.UserAPIKey
}

// IsSuccess returns true when this rotate user Api key o k response has a 2xx status code
func (o *RotateUserAPIKeyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this rotate user Api key o k response has a 3xx status code
func (o *RotateUserAPIKeyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this rotate user Api key o k response has a 4xx status code
func (o *RotateUserAPIKeyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this rotate user Api key o k response has a 5xx status code
func (o *RotateUserAPIKeyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this rotate user Api key o k response a status code equal to that given
func (o *RotateUserAPIKeyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the rotate user Api key o k response
func (o *RotateUserAPIKeyOK) Code() int {
	return 200
}

func (o *RotateUserAPIKeyOK) Error() string {
	return fmt.Sprintf("[POST /users/db/{user_id}/rotate-key][%d] rotateUserApiKeyOK  %+v", 200, o.Payload)
}

func (o *RotateUserAPIKeyOK) String() string {
	return fmt.Sprintf("[POST /users/db/{user_id}/rotate-key][%d] rotateUserApiKeyOK  %+v", 200, o.Payload)
}

func (o *RotateUserAPIKeyOK) GetPayload() *models.UserAPIKey {
	return o.Payload
}

func (o *RotateUserAPIKeyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.UserAPIKey)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRotateUserAPIKeyBadRequest creates a RotateUserAPIKeyBadRequest with default headers values
func NewRotateUserAPIKeyBadRequest() *RotateUserAPIKeyBadRequest {
	return &RotateUserAPIKeyBadRequest{}
}

/*
RotateUserAPIKeyBadRequest describes a response with status code 400, with default header values.

Malformed request.
*/
type RotateUserAPIKeyBadRequest struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this rotate user Api key bad request response has a 2xx status code
func (o *RotateUserAPIKeyBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this rotate user Api key bad request response has a 3xx status code
func (o *RotateUserAPIKeyBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this rotate user Api key bad request response has a 4xx status code
func (o *RotateUserAPIKeyBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this rotate user Api key bad request response has a 5xx status code
func (o *RotateUserAPIKeyBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this rotate user Api key bad request response a status code equal to that given
func (o *RotateUserAPIKeyBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the rotate user Api key bad request response
func (o *RotateUserAPIKeyBadRequest) Code() int {
	return 400
}

func (o *RotateUserAPIKeyBadRequest) Error() string {
	return fmt.Sprintf("[POST /users/db/{user_id}/rotate-key][%d] rotateUserApiKeyBadRequest  %+v", 400, o.Payload)
}

func (o *RotateUserAPIKeyBadRequest) String() string {
	return fmt.Sprintf("[POST /users/db/{user_id}/rotate-key][%d] rotateUserApiKeyBadRequest  %+v", 400, o.Payload)
}

func (o *RotateUserAPIKeyBadRequest) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *RotateUserAPIKeyBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRotateUserAPIKeyUnauthorized creates a RotateUserAPIKeyUnauthorized with default headers values
func NewRotateUserAPIKeyUnauthorized() *RotateUserAPIKeyUnauthorized {
	return &RotateUserAPIKeyUnauthorized{}
}

/*
RotateUserAPIKeyUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type RotateUserAPIKeyUnauthorized struct {
}

// IsSuccess returns true when this rotate user Api key unauthorized response has a 2xx status code
func (o *RotateUserAPIKeyUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this rotate user Api key unauthorized response has a 3xx status code
func (o *RotateUserAPIKeyUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this rotate user Api key unauthorized response has a 4xx status code
func (o *RotateUserAPIKeyUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this rotate user Api key unauthorized response has a 5xx status code
func (o *RotateUserAPIKeyUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this rotate user Api key unauthorized response a status code equal to that given
func (o *RotateUserAPIKeyUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the rotate user Api key unauthorized response
func (o *RotateUserAPIKeyUnauthorized) Code() int {
	return 401
}

func (o *RotateUserAPIKeyUnauthorized) Error() string {
	return fmt.Sprintf("[POST /users/db/{user_id}/rotate-key][%d] rotateUserApiKeyUnauthorized ", 401)
}

func (o *RotateUserAPIKeyUnauthorized) String() string {
	return fmt.Sprintf("[POST /users/db/{user_id}/rotate-key][%d] rotateUserApiKeyUnauthorized ", 401)
}

func (o *RotateUserAPIKeyUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewRotateUserAPIKeyForbidden creates a RotateUserAPIKeyForbidden with default headers values
func NewRotateUserAPIKeyForbidden() *RotateUserAPIKeyForbidden {
	return &RotateUserAPIKeyForbidden{}
}

/*
RotateUserAPIKeyForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type RotateUserAPIKeyForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this rotate user Api key forbidden response has a 2xx status code
func (o *RotateUserAPIKeyForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this rotate user Api key forbidden response has a 3xx status code
func (o *RotateUserAPIKeyForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this rotate user Api key forbidden response has a 4xx status code
func (o *RotateUserAPIKeyForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this rotate user Api key forbidden response has a 5xx status code
func (o *RotateUserAPIKeyForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this rotate user Api key forbidden response a status code equal to that given
func (o *RotateUserAPIKeyForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the rotate user Api key forbidden response
func (o *RotateUserAPIKeyForbidden) Code() int {
	return 403
}

func (o *RotateUserAPIKeyForbidden) Error() string {
	return fmt.Sprintf("[POST /users/db/{user_id}/rotate-key][%d] rotateUserApiKeyForbidden  %+v", 403, o.Payload)
}

func (o *RotateUserAPIKeyForbidden) String() string {
	return fmt.Sprintf("[POST /users/db/{user_id}/rotate-key][%d] rotateUserApiKeyForbidden  %+v", 403, o.Payload)
}

func (o *RotateUserAPIKeyForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *RotateUserAPIKeyForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRotateUserAPIKeyNotFound creates a RotateUserAPIKeyNotFound with default headers values
func NewRotateUserAPIKeyNotFound() *RotateUserAPIKeyNotFound {
	return &RotateUserAPIKeyNotFound{}
}

/*
RotateUserAPIKeyNotFound describes a response with status code 404, with default header values.

User not found.
*/
type RotateUserAPIKeyNotFound struct {
}

// IsSuccess returns true when this rotate user Api key not found response has a 2xx status code
func (o *RotateUserAPIKeyNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this rotate user Api key not found response has a 3xx status code
func (o *RotateUserAPIKeyNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this rotate user Api key not found response has a 4xx status code
func (o *RotateUserAPIKeyNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this rotate user Api key not found response has a 5xx status code
func (o *RotateUserAPIKeyNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this rotate user Api key not found response a status code equal to that given
func (o *RotateUserAPIKeyNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the rotate user Api key not found response
func (o *RotateUserAPIKeyNotFound) Code() int {
	return 404
}

func (o *RotateUserAPIKeyNotFound) Error() string {
	return fmt.Sprintf("[POST /users/db/{user_id}/rotate-key][%d] rotateUserApiKeyNotFound ", 404)
}

func (o *RotateUserAPIKeyNotFound) String() string {
	return fmt.Sprintf("[POST /users/db/{user_id}/rotate-key][%d] rotateUserApiKeyNotFound ", 404)
}

func (o *RotateUserAPIKeyNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewRotateUserAPIKeyUnprocessableEntity creates a RotateUserAPIKeyUnprocessableEntity with default headers values
func NewRotateUserAPIKeyUnprocessableEntity() *RotateUserAPIKeyUnprocessableEntity {
	return &RotateUserAPIKeyUnprocessableEntity{}
}

/*
RotateUserAPIKeyUnprocessableEntity describes a response with status code 422, with default header values.

The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.
*/
type RotateUserAPIKeyUnprocessableEntity struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this rotate user Api key unprocessable entity response has a 2xx status code
func (o *RotateUserAPIKeyUnprocessableEntity) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this rotate user Api key unprocessable entity response has a 3xx status code
func (o *RotateUserAPIKeyUnprocessableEntity) IsRedirect() bool {
	return false
}

// IsClientError returns true when this rotate user Api key unprocessable entity response has a 4xx status code
func (o *RotateUserAPIKeyUnprocessableEntity) IsClientError() bool {
	return true
}

// IsServerError returns true when this rotate user Api key unprocessable entity response has a 5xx status code
func (o *RotateUserAPIKeyUnprocessableEntity) IsServerError() bool {
	return false
}

// IsCode returns true when this rotate user Api key unprocessable entity response a status code equal to that given
func (o *RotateUserAPIKeyUnprocessableEntity) IsCode(code int) bool {
	return code == 422
}

// Code gets the status code for the rotate user Api key unprocessable entity response
func (o *RotateUserAPIKeyUnprocessableEntity) Code() int {
	return 422
}

func (o *RotateUserAPIKeyUnprocessableEntity) Error() string {
	return fmt.Sprintf("[POST /users/db/{user_id}/rotate-key][%d] rotateUserApiKeyUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *RotateUserAPIKeyUnprocessableEntity) String() string {
	return fmt.Sprintf("[POST /users/db/{user_id}/rotate-key][%d] rotateUserApiKeyUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *RotateUserAPIKeyUnprocessableEntity) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *RotateUserAPIKeyUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRotateUserAPIKeyInternalServerError creates a RotateUserAPIKeyInternalServerError with default headers values
func NewRotateUserAPIKeyInternalServerError() *RotateUserAPIKeyInternalServerError {
	return &RotateUserAPIKeyInternalServerError{}
}

/*
RotateUserAPIKeyInternalServerError describes a response with status code 500, with default header values.

An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.
*/
type RotateUserAPIKeyInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this rotate user Api key internal server error response has a 2xx status code
func (o *RotateUserAPIKeyInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this rotate user Api key internal server error response has a 3xx status code
func (o *RotateUserAPIKeyInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this rotate user Api key internal server error response has a 4xx status code
func (o *RotateUserAPIKeyInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this rotate user Api key internal server error response has a 5xx status code
func (o *RotateUserAPIKeyInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this rotate user Api key internal server error response a status code equal to that given
func (o *RotateUserAPIKeyInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the rotate user Api key internal server error response
func (o *RotateUserAPIKeyInternalServerError) Code() int {
	return 500
}

func (o *RotateUserAPIKeyInternalServerError) Error() string {
	return fmt.Sprintf("[POST /users/db/{user_id}/rotate-key][%d] rotateUserApiKeyInternalServerError  %+v", 500, o.Payload)
}

func (o *RotateUserAPIKeyInternalServerError) String() string {
	return fmt.Sprintf("[POST /users/db/{user_id}/rotate-key][%d] rotateUserApiKeyInternalServerError  %+v", 500, o.Payload)
}

func (o *RotateUserAPIKeyInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *RotateUserAPIKeyInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
