//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// BackupConfig Backup custom configuration.
//
// swagger:model BackupConfig
type BackupConfig struct {

	// Name of the bucket, container, volume, etc.
	Bucket string `json:"Bucket,omitempty"`

	// Desired CPU core utilization ranging from 1%-80%
	// Maximum: 80
	// Minimum: 1
	CPUPercentage int64 `json:"CPUPercentage,omitempty"`

	// Deprecated, has no effect.
	ChunkSize int64 `json:"ChunkSize,omitempty"`

	// compression level used by compression algorithm
	// Enum: [DefaultCompression BestSpeed BestCompression ZstdDefaultCompression ZstdBestSpeed ZstdBestCompression NoCompression]
	CompressionLevel string `json:"CompressionLevel,omitempty"`

	// Name of the endpoint, e.g. s3.amazonaws.com.
	Endpoint string `json:"Endpoint,omitempty"`

	// Path or key within the bucket.
	Path string `json:"Path,omitempty"`
}

// Validate validates this backup config
func (m *BackupConfig) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCPUPercentage(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCompressionLevel(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BackupConfig) validateCPUPercentage(formats strfmt.Registry) error {
	if swag.IsZero(m.CPUPercentage) { // not required
		return nil
	}

	if err := validate.MinimumInt("CPUPercentage", "body", m.CPUPercentage, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("CPUPercentage", "body", m.CPUPercentage, 80, false); err != nil {
		return err
	}

	return nil
}

var backupConfigTypeCompressionLevelPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["DefaultCompression","BestSpeed","BestCompression","ZstdDefaultCompression","ZstdBestSpeed","ZstdBestCompression","NoCompression"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		backupConfigTypeCompressionLevelPropEnum = append(backupConfigTypeCompressionLevelPropEnum, v)
	}
}

const (

	// BackupConfigCompressionLevelDefaultCompression captures enum value "DefaultCompression"
	BackupConfigCompressionLevelDefaultCompression string = "DefaultCompression"

	// BackupConfigCompressionLevelBestSpeed captures enum value "BestSpeed"
	BackupConfigCompressionLevelBestSpeed string = "BestSpeed"

	// BackupConfigCompressionLevelBestCompression captures enum value "BestCompression"
	BackupConfigCompressionLevelBestCompression string = "BestCompression"

	// BackupConfigCompressionLevelZstdDefaultCompression captures enum value "ZstdDefaultCompression"
	BackupConfigCompressionLevelZstdDefaultCompression string = "ZstdDefaultCompression"

	// BackupConfigCompressionLevelZstdBestSpeed captures enum value "ZstdBestSpeed"
	BackupConfigCompressionLevelZstdBestSpeed string = "ZstdBestSpeed"

	// BackupConfigCompressionLevelZstdBestCompression captures enum value "ZstdBestCompression"
	BackupConfigCompressionLevelZstdBestCompression string = "ZstdBestCompression"

	// BackupConfigCompressionLevelNoCompression captures enum value "NoCompression"
	BackupConfigCompressionLevelNoCompression string = "NoCompression"
)

// prop value enum
func (m *BackupConfig) validateCompressionLevelEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, backupConfigTypeCompressionLevelPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BackupConfig) validateCompressionLevel(formats strfmt.Registry) error {
	if swag.IsZero(m.CompressionLevel) { // not required
		return nil
	}

	// value enum
	if err := m.validateCompressionLevelEnum("CompressionLevel", "body", m.CompressionLevel); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this backup config based on context it is used
func (m *BackupConfig) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *BackupConfig) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *BackupConfig) UnmarshalBinary(b []byte) error {
	var res BackupConfig
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
