//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/validate"
)

// GroupType If the group contains OIDC or database users.
//
// swagger:model GroupType
type GroupType string

func NewGroupType(value GroupType) *GroupType {
	return &value
}

// Pointer returns a pointer to a freshly-allocated GroupType.
func (m GroupType) Pointer() *GroupType {
	return &m
}

const (

	// GroupTypeOidc captures enum value "oidc"
	GroupTypeOidc GroupType = "oidc"
)

// for schema
var groupTypeEnum []interface{}

func init() {
	var res []GroupType
	if err := json.Unmarshal([]byte(`["oidc"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		groupTypeEnum = append(groupTypeEnum, v)
	}
}

func (m GroupType) validateGroupTypeEnum(path, location string, value GroupType) error {
	if err := validate.EnumCase(path, location, value, groupTypeEnum, true); err != nil {
		return err
	}
	return nil
}

// Validate validates this group type
func (m GroupType) Validate(formats strfmt.Registry) error {
	var res []error

	// value enum
	if err := m.validateGroupTypeEnum("", "body", m); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// ContextValidate validates this group type based on context it is used
func (m GroupType) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}
