//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// Principal principal
//
// swagger:model Principal
type Principal struct {

	// groups
	Groups []string `json:"groups"`

	// user type
	UserType UserTypeInput `json:"userType,omitempty"`

	// The username that was extracted either from the authentication information
	Username string `json:"username,omitempty"`
}

// Validate validates this principal
func (m *Principal) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateUserType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Principal) validateUserType(formats strfmt.Registry) error {
	if swag.IsZero(m.UserType) { // not required
		return nil
	}

	if err := m.UserType.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("userType")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("userType")
		}
		return err
	}

	return nil
}

// ContextValidate validate this principal based on the context it is used
func (m *Principal) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateUserType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Principal) contextValidateUserType(ctx context.Context, formats strfmt.Registry) error {

	if err := m.UserType.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("userType")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("userType")
		}
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Principal) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Principal) UnmarshalBinary(b []byte) error {
	var res Principal
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
