//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ReplicationDisableReplicaRequest Specifies the parameters required to mark a specific shard replica as inactive (soft-delete) on a particular node. This action typically prevents the replica from serving requests but does not immediately remove its data.
//
// swagger:model ReplicationDisableReplicaRequest
type ReplicationDisableReplicaRequest struct {

	// The name of the collection to which the shard replica belongs.
	// Required: true
	Collection *string `json:"collection"`

	// The name of the Weaviate node hosting the shard replica that is to be disabled.
	// Required: true
	Node *string `json:"node"`

	// The ID of the shard whose replica is to be disabled.
	// Required: true
	Shard *string `json:"shard"`
}

// Validate validates this replication disable replica request
func (m *ReplicationDisableReplicaRequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCollection(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateShard(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ReplicationDisableReplicaRequest) validateCollection(formats strfmt.Registry) error {

	if err := validate.Required("collection", "body", m.Collection); err != nil {
		return err
	}

	return nil
}

func (m *ReplicationDisableReplicaRequest) validateNode(formats strfmt.Registry) error {

	if err := validate.Required("node", "body", m.Node); err != nil {
		return err
	}

	return nil
}

func (m *ReplicationDisableReplicaRequest) validateShard(formats strfmt.Registry) error {

	if err := validate.Required("shard", "body", m.Shard); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this replication disable replica request based on context it is used
func (m *ReplicationDisableReplicaRequest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ReplicationDisableReplicaRequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ReplicationDisableReplicaRequest) UnmarshalBinary(b []byte) error {
	var res ReplicationDisableReplicaRequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
