//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ReplicationReplicateForceDeleteRequest Specifies the parameters available when force deleting replication operations.
//
// swagger:model ReplicationReplicateForceDeleteRequest
type ReplicationReplicateForceDeleteRequest struct {

	// The name of the collection to which the shard being replicated belongs.
	Collection string `json:"collection,omitempty"`

	// If true, the operation will not actually delete anything but will return the expected outcome of the deletion.
	DryRun *bool `json:"dryRun,omitempty"`

	// The unique identifier (ID) of the replication operation to be forcefully deleted.
	// Format: uuid
	ID strfmt.UUID `json:"id,omitempty"`

	// The name of the target node where the replication operations are registered.
	Node string `json:"node,omitempty"`

	// The identifier of the shard involved in the replication operations.
	Shard string `json:"shard,omitempty"`
}

// Validate validates this replication replicate force delete request
func (m *ReplicationReplicateForceDeleteRequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ReplicationReplicateForceDeleteRequest) validateID(formats strfmt.Registry) error {
	if swag.IsZero(m.ID) { // not required
		return nil
	}

	if err := validate.FormatOf("id", "body", "uuid", m.ID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this replication replicate force delete request based on context it is used
func (m *ReplicationReplicateForceDeleteRequest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ReplicationReplicateForceDeleteRequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ReplicationReplicateForceDeleteRequest) UnmarshalBinary(b []byte) error {
	var res ReplicationReplicateForceDeleteRequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
