//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ReplicationReplicateReplicaRequest Specifies the parameters required to initiate a shard replica movement operation between two nodes for a given collection and shard. This request defines the source and target node, the collection and type of transfer.
//
// swagger:model ReplicationReplicateReplicaRequest
type ReplicationReplicateReplicaRequest struct {

	// The name of the collection to which the target shard belongs.
	// Required: true
	Collection *string `json:"collection"`

	// The name of the shard whose replica is to be moved or copied.
	// Required: true
	Shard *string `json:"shard"`

	// The name of the Weaviate node currently hosting the shard replica that needs to be moved or copied.
	// Required: true
	SourceNode *string `json:"sourceNode"`

	// The name of the Weaviate node where the new shard replica will be created as part of the movement or copy operation.
	// Required: true
	TargetNode *string `json:"targetNode"`

	// Specifies the type of replication operation to perform. `COPY` creates a new replica on the target node while keeping the source replica. `MOVE` creates a new replica on the target node and then removes the source replica upon successful completion. Defaults to `COPY` if omitted.
	// Enum: [COPY MOVE]
	Type *string `json:"type,omitempty"`
}

// Validate validates this replication replicate replica request
func (m *ReplicationReplicateReplicaRequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCollection(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateShard(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSourceNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTargetNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ReplicationReplicateReplicaRequest) validateCollection(formats strfmt.Registry) error {

	if err := validate.Required("collection", "body", m.Collection); err != nil {
		return err
	}

	return nil
}

func (m *ReplicationReplicateReplicaRequest) validateShard(formats strfmt.Registry) error {

	if err := validate.Required("shard", "body", m.Shard); err != nil {
		return err
	}

	return nil
}

func (m *ReplicationReplicateReplicaRequest) validateSourceNode(formats strfmt.Registry) error {

	if err := validate.Required("sourceNode", "body", m.SourceNode); err != nil {
		return err
	}

	return nil
}

func (m *ReplicationReplicateReplicaRequest) validateTargetNode(formats strfmt.Registry) error {

	if err := validate.Required("targetNode", "body", m.TargetNode); err != nil {
		return err
	}

	return nil
}

var replicationReplicateReplicaRequestTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["COPY","MOVE"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		replicationReplicateReplicaRequestTypeTypePropEnum = append(replicationReplicateReplicaRequestTypeTypePropEnum, v)
	}
}

const (

	// ReplicationReplicateReplicaRequestTypeCOPY captures enum value "COPY"
	ReplicationReplicateReplicaRequestTypeCOPY string = "COPY"

	// ReplicationReplicateReplicaRequestTypeMOVE captures enum value "MOVE"
	ReplicationReplicateReplicaRequestTypeMOVE string = "MOVE"
)

// prop value enum
func (m *ReplicationReplicateReplicaRequest) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, replicationReplicateReplicaRequestTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ReplicationReplicateReplicaRequest) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this replication replicate replica request based on context it is used
func (m *ReplicationReplicateReplicaRequest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ReplicationReplicateReplicaRequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ReplicationReplicateReplicaRequest) UnmarshalBinary(b []byte) error {
	var res ReplicationReplicateReplicaRequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
