//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ReplicationScaleApplyResponse Response for the POST /replication/scale endpoint containing the list of initiated shard copy operation IDs.
//
// swagger:model ReplicationScaleApplyResponse
type ReplicationScaleApplyResponse struct {

	// The name of the collection associated with this replication scaling plan.
	// Required: true
	Collection string `json:"collection"`

	// List of shard copy operation IDs created during scaling.
	// Required: true
	OperationIds []strfmt.UUID `json:"operationIds"`

	// The unique identifier of the replication scaling plan that generated these operations.
	// Required: true
	// Format: uuid
	PlanID strfmt.UUID `json:"planId"`
}

// Validate validates this replication scale apply response
func (m *ReplicationScaleApplyResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCollection(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOperationIds(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePlanID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ReplicationScaleApplyResponse) validateCollection(formats strfmt.Registry) error {

	if err := validate.RequiredString("collection", "body", m.Collection); err != nil {
		return err
	}

	return nil
}

func (m *ReplicationScaleApplyResponse) validateOperationIds(formats strfmt.Registry) error {

	if err := validate.Required("operationIds", "body", m.OperationIds); err != nil {
		return err
	}

	for i := 0; i < len(m.OperationIds); i++ {

		if err := validate.FormatOf("operationIds"+"."+strconv.Itoa(i), "body", "uuid", m.OperationIds[i].String(), formats); err != nil {
			return err
		}

	}

	return nil
}

func (m *ReplicationScaleApplyResponse) validatePlanID(formats strfmt.Registry) error {

	if err := validate.Required("planId", "body", strfmt.UUID(m.PlanID)); err != nil {
		return err
	}

	if err := validate.FormatOf("planId", "body", "uuid", m.PlanID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this replication scale apply response based on context it is used
func (m *ReplicationScaleApplyResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ReplicationScaleApplyResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ReplicationScaleApplyResponse) UnmarshalBinary(b []byte) error {
	var res ReplicationScaleApplyResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
