//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ReplicationShardingState Details the sharding layout for a specific collection, mapping each shard to its set of replicas across the cluster.
//
// swagger:model ReplicationShardingState
type ReplicationShardingState struct {

	// The name of the collection.
	Collection string `json:"collection,omitempty"`

	// An array detailing each shard within the collection and the nodes hosting its replicas.
	Shards []*ReplicationShardReplicas `json:"shards"`
}

// Validate validates this replication sharding state
func (m *ReplicationShardingState) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateShards(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ReplicationShardingState) validateShards(formats strfmt.Registry) error {
	if swag.IsZero(m.Shards) { // not required
		return nil
	}

	for i := 0; i < len(m.Shards); i++ {
		if swag.IsZero(m.Shards[i]) { // not required
			continue
		}

		if m.Shards[i] != nil {
			if err := m.Shards[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("shards" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("shards" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this replication sharding state based on the context it is used
func (m *ReplicationShardingState) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateShards(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ReplicationShardingState) contextValidateShards(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Shards); i++ {

		if m.Shards[i] != nil {
			if err := m.Shards[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("shards" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("shards" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ReplicationShardingState) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ReplicationShardingState) UnmarshalBinary(b []byte) error {
	var res ReplicationShardingState
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
