//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ReplicationShardingStateResponse Provides the detailed sharding state for one or more collections, including the distribution of shards and their replicas across the cluster nodes.
//
// swagger:model ReplicationShardingStateResponse
type ReplicationShardingStateResponse struct {

	// sharding state
	ShardingState *ReplicationShardingState `json:"shardingState,omitempty"`
}

// Validate validates this replication sharding state response
func (m *ReplicationShardingStateResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateShardingState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ReplicationShardingStateResponse) validateShardingState(formats strfmt.Registry) error {
	if swag.IsZero(m.ShardingState) { // not required
		return nil
	}

	if m.ShardingState != nil {
		if err := m.ShardingState.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("shardingState")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("shardingState")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this replication sharding state response based on the context it is used
func (m *ReplicationShardingStateResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateShardingState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ReplicationShardingStateResponse) contextValidateShardingState(ctx context.Context, formats strfmt.Registry) error {

	if m.ShardingState != nil {
		if err := m.ShardingState.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("shardingState")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("shardingState")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ReplicationShardingStateResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ReplicationShardingStateResponse) UnmarshalBinary(b []byte) error {
	var res ReplicationShardingStateResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
