//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Statistics The definition of node statistics.
//
// swagger:model Statistics
type Statistics struct {

	// bootstrapped
	Bootstrapped bool `json:"bootstrapped,omitempty"`

	// candidates
	Candidates interface{} `json:"candidates,omitempty"`

	// db loaded
	DbLoaded bool `json:"dbLoaded,omitempty"`

	// initial last applied index
	InitialLastAppliedIndex uint64 `json:"initialLastAppliedIndex,omitempty"`

	// is voter
	IsVoter bool `json:"isVoter,omitempty"`

	// last applied index
	LastAppliedIndex float64 `json:"lastAppliedIndex,omitempty"`

	// leader address
	LeaderAddress interface{} `json:"leaderAddress,omitempty"`

	// leader Id
	LeaderID interface{} `json:"leaderId,omitempty"`

	// The name of the node.
	Name string `json:"name,omitempty"`

	// open
	Open bool `json:"open,omitempty"`

	// Weaviate Raft statistics.
	Raft *RaftStatistics `json:"raft,omitempty"`

	// ready
	Ready bool `json:"ready,omitempty"`

	// Node's status.
	// Enum: [HEALTHY UNHEALTHY UNAVAILABLE TIMEOUT]
	Status *string `json:"status,omitempty"`
}

// Validate validates this statistics
func (m *Statistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateRaft(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Statistics) validateRaft(formats strfmt.Registry) error {
	if swag.IsZero(m.Raft) { // not required
		return nil
	}

	if m.Raft != nil {
		if err := m.Raft.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("raft")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("raft")
			}
			return err
		}
	}

	return nil
}

var statisticsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["HEALTHY","UNHEALTHY","UNAVAILABLE","TIMEOUT"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		statisticsTypeStatusPropEnum = append(statisticsTypeStatusPropEnum, v)
	}
}

const (

	// StatisticsStatusHEALTHY captures enum value "HEALTHY"
	StatisticsStatusHEALTHY string = "HEALTHY"

	// StatisticsStatusUNHEALTHY captures enum value "UNHEALTHY"
	StatisticsStatusUNHEALTHY string = "UNHEALTHY"

	// StatisticsStatusUNAVAILABLE captures enum value "UNAVAILABLE"
	StatisticsStatusUNAVAILABLE string = "UNAVAILABLE"

	// StatisticsStatusTIMEOUT captures enum value "TIMEOUT"
	StatisticsStatusTIMEOUT string = "TIMEOUT"
)

// prop value enum
func (m *Statistics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, statisticsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Statistics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this statistics based on the context it is used
func (m *Statistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateRaft(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Statistics) contextValidateRaft(ctx context.Context, formats strfmt.Registry) error {

	if m.Raft != nil {
		if err := m.Raft.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("raft")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("raft")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Statistics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Statistics) UnmarshalBinary(b []byte) error {
	var res Statistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
