//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// TokenizerUserDictConfig A list of pairs of strings that should be replaced with another string during tokenization.
//
// swagger:model TokenizerUserDictConfig
type TokenizerUserDictConfig struct {

	// replacements
	Replacements []*TokenizerUserDictConfigReplacementsItems0 `json:"replacements"`

	// The tokenizer to which the user dictionary should be applied. Currently, only the `kagame` ja and kr tokenizers supports user dictionaries.
	Tokenizer string `json:"tokenizer,omitempty"`
}

// Validate validates this tokenizer user dict config
func (m *TokenizerUserDictConfig) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateReplacements(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TokenizerUserDictConfig) validateReplacements(formats strfmt.Registry) error {
	if swag.IsZero(m.Replacements) { // not required
		return nil
	}

	for i := 0; i < len(m.Replacements); i++ {
		if swag.IsZero(m.Replacements[i]) { // not required
			continue
		}

		if m.Replacements[i] != nil {
			if err := m.Replacements[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("replacements" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("replacements" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this tokenizer user dict config based on the context it is used
func (m *TokenizerUserDictConfig) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateReplacements(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TokenizerUserDictConfig) contextValidateReplacements(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Replacements); i++ {

		if m.Replacements[i] != nil {
			if err := m.Replacements[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("replacements" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("replacements" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *TokenizerUserDictConfig) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TokenizerUserDictConfig) UnmarshalBinary(b []byte) error {
	var res TokenizerUserDictConfig
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// TokenizerUserDictConfigReplacementsItems0 tokenizer user dict config replacements items0
//
// swagger:model TokenizerUserDictConfigReplacementsItems0
type TokenizerUserDictConfigReplacementsItems0 struct {

	// The string to be replaced.
	// Required: true
	Source *string `json:"source"`

	// The string to replace with.
	// Required: true
	Target *string `json:"target"`
}

// Validate validates this tokenizer user dict config replacements items0
func (m *TokenizerUserDictConfigReplacementsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSource(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTarget(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TokenizerUserDictConfigReplacementsItems0) validateSource(formats strfmt.Registry) error {

	if err := validate.Required("source", "body", m.Source); err != nil {
		return err
	}

	return nil
}

func (m *TokenizerUserDictConfigReplacementsItems0) validateTarget(formats strfmt.Registry) error {

	if err := validate.Required("target", "body", m.Target); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this tokenizer user dict config replacements items0 based on context it is used
func (m *TokenizerUserDictConfigReplacementsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *TokenizerUserDictConfigReplacementsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TokenizerUserDictConfigReplacementsItems0) UnmarshalBinary(b []byte) error {
	var res TokenizerUserDictConfigReplacementsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
