//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/validate"
)

// UserTypeOutput The type of the user. `db_user` users are created through the `users` API, `db_env_user` users are created through environment variables, and `oidc` users are managed by an external OIDC provider.
//
// swagger:model UserTypeOutput
type UserTypeOutput string

func NewUserTypeOutput(value UserTypeOutput) *UserTypeOutput {
	return &value
}

// Pointer returns a pointer to a freshly-allocated UserTypeOutput.
func (m UserTypeOutput) Pointer() *UserTypeOutput {
	return &m
}

const (

	// UserTypeOutputDbUser captures enum value "db_user"
	UserTypeOutputDbUser UserTypeOutput = "db_user"

	// UserTypeOutputDbEnvUser captures enum value "db_env_user"
	UserTypeOutputDbEnvUser UserTypeOutput = "db_env_user"

	// UserTypeOutputOidc captures enum value "oidc"
	UserTypeOutputOidc UserTypeOutput = "oidc"
)

// for schema
var userTypeOutputEnum []interface{}

func init() {
	var res []UserTypeOutput
	if err := json.Unmarshal([]byte(`["db_user","db_env_user","oidc"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		userTypeOutputEnum = append(userTypeOutputEnum, v)
	}
}

func (m UserTypeOutput) validateUserTypeOutputEnum(path, location string, value UserTypeOutput) error {
	if err := validate.EnumCase(path, location, value, userTypeOutputEnum, true); err != nil {
		return err
	}
	return nil
}

// Validate validates this user type output
func (m UserTypeOutput) Validate(formats strfmt.Registry) error {
	var res []error

	// value enum
	if err := m.validateUserTypeOutputEnum("", "body", m); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// ContextValidate validates this user type output based on context it is used
func (m UserTypeOutput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}
