//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

package modulecapabilities

import (
	"context"

	"github.com/weaviate/weaviate/entities/dto"
	"github.com/weaviate/weaviate/entities/models"

	"github.com/tailor-platform/graphql"
	"github.com/tailor-platform/graphql/language/ast"
	"github.com/weaviate/weaviate/entities/moduletools"
	"github.com/weaviate/weaviate/entities/search"
)

// GraphQLFieldFn generates graphql field based on classname
type GraphQLFieldFn = func(classname string) *graphql.Field

// ExtractAdditionalFn extracts parameters from graphql queries
type ExtractAdditionalFn = func(param []*ast.Argument, class *models.Class) any

// AdditionalPropertyWithSearchVector defines additional property params
// with the ability to pass search vector
type AdditionalPropertyWithSearchVector[T dto.Embedding] interface {
	SetSearchVector(vector T)
}

// AdditionalPropertyFn defines interface for additional property
// functions performing given logic
type AdditionalPropertyFn = func(ctx context.Context,
	in []search.Result, params any, limit *int,
	argumentModuleParams map[string]any, cfg moduletools.ClassConfig) ([]search.Result, error)

// AdditionalSearch defines on which type of query a given
// additional logic can be performed
type AdditionalSearch struct {
	ObjectGet   AdditionalPropertyFn
	ObjectList  AdditionalPropertyFn
	ExploreGet  AdditionalPropertyFn
	ExploreList AdditionalPropertyFn
}

// AdditionalProperty defines all the needed settings / methods
// to be set in order to add the additional property to Weaviate
type AdditionalProperty struct {
	RestNames              []string
	DefaultValue           any
	GraphQLNames           []string
	GraphQLFieldFunction   GraphQLFieldFn
	GraphQLExtractFunction ExtractAdditionalFn
	SearchFunctions        AdditionalSearch
}

// AdditionalProperties groups whole interface methods needed
// for adding the capability of additional properties
type AdditionalProperties interface {
	AdditionalProperties() map[string]AdditionalProperty
}
