//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"context"
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/weaviate/weaviate/entities/models"
)

// GetGroupsForRoleHandlerFunc turns a function with the right signature into a get groups for role handler
type GetGroupsForRoleHandlerFunc func(GetGroupsForRoleParams, *models.Principal) middleware.Responder

// Handle executing the request and returning a response
func (fn GetGroupsForRoleHandlerFunc) Handle(params GetGroupsForRoleParams, principal *models.Principal) middleware.Responder {
	return fn(params, principal)
}

// GetGroupsForRoleHandler interface for that can handle valid get groups for role params
type GetGroupsForRoleHandler interface {
	Handle(GetGroupsForRoleParams, *models.Principal) middleware.Responder
}

// NewGetGroupsForRole creates a new http.Handler for the get groups for role operation
func NewGetGroupsForRole(ctx *middleware.Context, handler GetGroupsForRoleHandler) *GetGroupsForRole {
	return &GetGroupsForRole{Context: ctx, Handler: handler}
}

/*
	GetGroupsForRole swagger:route GET /authz/roles/{id}/group-assignments authz getGroupsForRole

# Get groups that have a specific role assigned

Retrieves a list of all groups that have been assigned a specific role, identified by its name.
*/
type GetGroupsForRole struct {
	Context *middleware.Context
	Handler GetGroupsForRoleHandler
}

func (o *GetGroupsForRole) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		*r = *rCtx
	}
	var Params = NewGetGroupsForRoleParams()
	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		*r = *aCtx
	}
	var principal *models.Principal
	if uprinc != nil {
		principal = uprinc.(*models.Principal) // this is really a models.Principal, I promise
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request
	o.Context.Respond(rw, r, route.Produces, route, res)

}

// GetGroupsForRoleOKBodyItems0 get groups for role o k body items0
//
// swagger:model GetGroupsForRoleOKBodyItems0
type GetGroupsForRoleOKBodyItems0 struct {

	// group Id
	GroupID string `json:"groupId,omitempty" yaml:"groupId,omitempty"`

	// group type
	// Required: true
	GroupType *models.GroupType `json:"groupType" yaml:"groupType"`
}

// Validate validates this get groups for role o k body items0
func (o *GetGroupsForRoleOKBodyItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateGroupType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GetGroupsForRoleOKBodyItems0) validateGroupType(formats strfmt.Registry) error {

	if err := validate.Required("groupType", "body", o.GroupType); err != nil {
		return err
	}

	if err := validate.Required("groupType", "body", o.GroupType); err != nil {
		return err
	}

	if o.GroupType != nil {
		if err := o.GroupType.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("groupType")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("groupType")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this get groups for role o k body items0 based on the context it is used
func (o *GetGroupsForRoleOKBodyItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateGroupType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GetGroupsForRoleOKBodyItems0) contextValidateGroupType(ctx context.Context, formats strfmt.Registry) error {

	if o.GroupType != nil {
		if err := o.GroupType.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("groupType")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("groupType")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *GetGroupsForRoleOKBodyItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *GetGroupsForRoleOKBodyItems0) UnmarshalBinary(b []byte) error {
	var res GetGroupsForRoleOKBodyItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
