//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// GetGroupsForRoleOKCode is the HTTP code returned for type GetGroupsForRoleOK
const GetGroupsForRoleOKCode int = 200

/*
GetGroupsForRoleOK Successfully retrieved the list of groups that have the role assigned.

swagger:response getGroupsForRoleOK
*/
type GetGroupsForRoleOK struct {

	/*
	  In: Body
	*/
	Payload []*GetGroupsForRoleOKBodyItems0 `json:"body,omitempty"`
}

// NewGetGroupsForRoleOK creates GetGroupsForRoleOK with default headers values
func NewGetGroupsForRoleOK() *GetGroupsForRoleOK {

	return &GetGroupsForRoleOK{}
}

// WithPayload adds the payload to the get groups for role o k response
func (o *GetGroupsForRoleOK) WithPayload(payload []*GetGroupsForRoleOKBodyItems0) *GetGroupsForRoleOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get groups for role o k response
func (o *GetGroupsForRoleOK) SetPayload(payload []*GetGroupsForRoleOKBodyItems0) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetGroupsForRoleOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = make([]*GetGroupsForRoleOKBodyItems0, 0, 50)
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// GetGroupsForRoleBadRequestCode is the HTTP code returned for type GetGroupsForRoleBadRequest
const GetGroupsForRoleBadRequestCode int = 400

/*
GetGroupsForRoleBadRequest Bad request

swagger:response getGroupsForRoleBadRequest
*/
type GetGroupsForRoleBadRequest struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewGetGroupsForRoleBadRequest creates GetGroupsForRoleBadRequest with default headers values
func NewGetGroupsForRoleBadRequest() *GetGroupsForRoleBadRequest {

	return &GetGroupsForRoleBadRequest{}
}

// WithPayload adds the payload to the get groups for role bad request response
func (o *GetGroupsForRoleBadRequest) WithPayload(payload *models.ErrorResponse) *GetGroupsForRoleBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get groups for role bad request response
func (o *GetGroupsForRoleBadRequest) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetGroupsForRoleBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetGroupsForRoleUnauthorizedCode is the HTTP code returned for type GetGroupsForRoleUnauthorized
const GetGroupsForRoleUnauthorizedCode int = 401

/*
GetGroupsForRoleUnauthorized Unauthorized or invalid credentials.

swagger:response getGroupsForRoleUnauthorized
*/
type GetGroupsForRoleUnauthorized struct {
}

// NewGetGroupsForRoleUnauthorized creates GetGroupsForRoleUnauthorized with default headers values
func NewGetGroupsForRoleUnauthorized() *GetGroupsForRoleUnauthorized {

	return &GetGroupsForRoleUnauthorized{}
}

// WriteResponse to the client
func (o *GetGroupsForRoleUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// GetGroupsForRoleForbiddenCode is the HTTP code returned for type GetGroupsForRoleForbidden
const GetGroupsForRoleForbiddenCode int = 403

/*
GetGroupsForRoleForbidden Forbidden

swagger:response getGroupsForRoleForbidden
*/
type GetGroupsForRoleForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewGetGroupsForRoleForbidden creates GetGroupsForRoleForbidden with default headers values
func NewGetGroupsForRoleForbidden() *GetGroupsForRoleForbidden {

	return &GetGroupsForRoleForbidden{}
}

// WithPayload adds the payload to the get groups for role forbidden response
func (o *GetGroupsForRoleForbidden) WithPayload(payload *models.ErrorResponse) *GetGroupsForRoleForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get groups for role forbidden response
func (o *GetGroupsForRoleForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetGroupsForRoleForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetGroupsForRoleNotFoundCode is the HTTP code returned for type GetGroupsForRoleNotFound
const GetGroupsForRoleNotFoundCode int = 404

/*
GetGroupsForRoleNotFound The specified role was not found.

swagger:response getGroupsForRoleNotFound
*/
type GetGroupsForRoleNotFound struct {
}

// NewGetGroupsForRoleNotFound creates GetGroupsForRoleNotFound with default headers values
func NewGetGroupsForRoleNotFound() *GetGroupsForRoleNotFound {

	return &GetGroupsForRoleNotFound{}
}

// WriteResponse to the client
func (o *GetGroupsForRoleNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(404)
}

// GetGroupsForRoleInternalServerErrorCode is the HTTP code returned for type GetGroupsForRoleInternalServerError
const GetGroupsForRoleInternalServerErrorCode int = 500

/*
GetGroupsForRoleInternalServerError An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.

swagger:response getGroupsForRoleInternalServerError
*/
type GetGroupsForRoleInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewGetGroupsForRoleInternalServerError creates GetGroupsForRoleInternalServerError with default headers values
func NewGetGroupsForRoleInternalServerError() *GetGroupsForRoleInternalServerError {

	return &GetGroupsForRoleInternalServerError{}
}

// WithPayload adds the payload to the get groups for role internal server error response
func (o *GetGroupsForRoleInternalServerError) WithPayload(payload *models.ErrorResponse) *GetGroupsForRoleInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get groups for role internal server error response
func (o *GetGroupsForRoleInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetGroupsForRoleInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
