//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// GetGroupsOKCode is the HTTP code returned for type GetGroupsOK
const GetGroupsOKCode int = 200

/*
GetGroupsOK A list of group names for the specified type.

swagger:response getGroupsOK
*/
type GetGroupsOK struct {

	/*
	  In: Body
	*/
	Payload []string `json:"body,omitempty"`
}

// NewGetGroupsOK creates GetGroupsOK with default headers values
func NewGetGroupsOK() *GetGroupsOK {

	return &GetGroupsOK{}
}

// WithPayload adds the payload to the get groups o k response
func (o *GetGroupsOK) WithPayload(payload []string) *GetGroupsOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get groups o k response
func (o *GetGroupsOK) SetPayload(payload []string) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetGroupsOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = make([]string, 0, 50)
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// GetGroupsBadRequestCode is the HTTP code returned for type GetGroupsBadRequest
const GetGroupsBadRequestCode int = 400

/*
GetGroupsBadRequest Bad request

swagger:response getGroupsBadRequest
*/
type GetGroupsBadRequest struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewGetGroupsBadRequest creates GetGroupsBadRequest with default headers values
func NewGetGroupsBadRequest() *GetGroupsBadRequest {

	return &GetGroupsBadRequest{}
}

// WithPayload adds the payload to the get groups bad request response
func (o *GetGroupsBadRequest) WithPayload(payload *models.ErrorResponse) *GetGroupsBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get groups bad request response
func (o *GetGroupsBadRequest) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetGroupsBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetGroupsUnauthorizedCode is the HTTP code returned for type GetGroupsUnauthorized
const GetGroupsUnauthorizedCode int = 401

/*
GetGroupsUnauthorized Unauthorized or invalid credentials.

swagger:response getGroupsUnauthorized
*/
type GetGroupsUnauthorized struct {
}

// NewGetGroupsUnauthorized creates GetGroupsUnauthorized with default headers values
func NewGetGroupsUnauthorized() *GetGroupsUnauthorized {

	return &GetGroupsUnauthorized{}
}

// WriteResponse to the client
func (o *GetGroupsUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// GetGroupsForbiddenCode is the HTTP code returned for type GetGroupsForbidden
const GetGroupsForbiddenCode int = 403

/*
GetGroupsForbidden Forbidden

swagger:response getGroupsForbidden
*/
type GetGroupsForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewGetGroupsForbidden creates GetGroupsForbidden with default headers values
func NewGetGroupsForbidden() *GetGroupsForbidden {

	return &GetGroupsForbidden{}
}

// WithPayload adds the payload to the get groups forbidden response
func (o *GetGroupsForbidden) WithPayload(payload *models.ErrorResponse) *GetGroupsForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get groups forbidden response
func (o *GetGroupsForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetGroupsForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetGroupsUnprocessableEntityCode is the HTTP code returned for type GetGroupsUnprocessableEntity
const GetGroupsUnprocessableEntityCode int = 422

/*
GetGroupsUnprocessableEntity The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.

swagger:response getGroupsUnprocessableEntity
*/
type GetGroupsUnprocessableEntity struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewGetGroupsUnprocessableEntity creates GetGroupsUnprocessableEntity with default headers values
func NewGetGroupsUnprocessableEntity() *GetGroupsUnprocessableEntity {

	return &GetGroupsUnprocessableEntity{}
}

// WithPayload adds the payload to the get groups unprocessable entity response
func (o *GetGroupsUnprocessableEntity) WithPayload(payload *models.ErrorResponse) *GetGroupsUnprocessableEntity {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get groups unprocessable entity response
func (o *GetGroupsUnprocessableEntity) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetGroupsUnprocessableEntity) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(422)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetGroupsInternalServerErrorCode is the HTTP code returned for type GetGroupsInternalServerError
const GetGroupsInternalServerErrorCode int = 500

/*
GetGroupsInternalServerError An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.

swagger:response getGroupsInternalServerError
*/
type GetGroupsInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewGetGroupsInternalServerError creates GetGroupsInternalServerError with default headers values
func NewGetGroupsInternalServerError() *GetGroupsInternalServerError {

	return &GetGroupsInternalServerError{}
}

// WithPayload adds the payload to the get groups internal server error response
func (o *GetGroupsInternalServerError) WithPayload(payload *models.ErrorResponse) *GetGroupsInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get groups internal server error response
func (o *GetGroupsInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetGroupsInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
