//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// NewGetRolesForGroupParams creates a new GetRolesForGroupParams object
// with the default values initialized.
func NewGetRolesForGroupParams() GetRolesForGroupParams {

	var (
		// initialize parameters with default values

		includeFullRolesDefault = bool(false)
	)

	return GetRolesForGroupParams{
		IncludeFullRoles: &includeFullRolesDefault,
	}
}

// GetRolesForGroupParams contains all the bound params for the get roles for group operation
// typically these are obtained from a http.Request
//
// swagger:parameters getRolesForGroup
type GetRolesForGroupParams struct {

	// HTTP Request Object
	HTTPRequest *http.Request `json:"-"`

	/*The type of the group.
	  Required: true
	  In: path
	*/
	GroupType string
	/*The unique name of the group.
	  Required: true
	  In: path
	*/
	ID string
	/*If true, the response will include the full role definitions with all associated permissions. If false, only role names are returned.
	  In: query
	  Default: false
	*/
	IncludeFullRoles *bool
}

// BindRequest both binds and validates a request, it assumes that complex things implement a Validatable(strfmt.Registry) error interface
// for simple values it will use straight method calls.
//
// To ensure default values, the struct must have been initialized with NewGetRolesForGroupParams() beforehand.
func (o *GetRolesForGroupParams) BindRequest(r *http.Request, route *middleware.MatchedRoute) error {
	var res []error

	o.HTTPRequest = r

	qs := runtime.Values(r.URL.Query())

	rGroupType, rhkGroupType, _ := route.Params.GetOK("groupType")
	if err := o.bindGroupType(rGroupType, rhkGroupType, route.Formats); err != nil {
		res = append(res, err)
	}

	rID, rhkID, _ := route.Params.GetOK("id")
	if err := o.bindID(rID, rhkID, route.Formats); err != nil {
		res = append(res, err)
	}

	qIncludeFullRoles, qhkIncludeFullRoles, _ := qs.GetOK("includeFullRoles")
	if err := o.bindIncludeFullRoles(qIncludeFullRoles, qhkIncludeFullRoles, route.Formats); err != nil {
		res = append(res, err)
	}
	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindGroupType binds and validates parameter GroupType from path.
func (o *GetRolesForGroupParams) bindGroupType(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: true
	// Parameter is provided by construction from the route
	o.GroupType = raw

	if err := o.validateGroupType(formats); err != nil {
		return err
	}

	return nil
}

// validateGroupType carries on validations for parameter GroupType
func (o *GetRolesForGroupParams) validateGroupType(formats strfmt.Registry) error {

	if err := validate.EnumCase("groupType", "path", o.GroupType, []interface{}{"oidc"}, true); err != nil {
		return err
	}

	return nil
}

// bindID binds and validates parameter ID from path.
func (o *GetRolesForGroupParams) bindID(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: true
	// Parameter is provided by construction from the route
	o.ID = raw

	return nil
}

// bindIncludeFullRoles binds and validates parameter IncludeFullRoles from query.
func (o *GetRolesForGroupParams) bindIncludeFullRoles(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false

	if raw == "" { // empty values pass all other validations
		// Default values have been previously initialized by NewGetRolesForGroupParams()
		return nil
	}

	value, err := swag.ConvertBool(raw)
	if err != nil {
		return errors.InvalidType("includeFullRoles", "query", "bool", raw)
	}
	o.IncludeFullRoles = &value

	return nil
}
