//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"net/http"

	"github.com/go-openapi/runtime/middleware"

	"github.com/weaviate/weaviate/entities/models"
)

// GetRolesForUserDeprecatedHandlerFunc turns a function with the right signature into a get roles for user deprecated handler
type GetRolesForUserDeprecatedHandlerFunc func(GetRolesForUserDeprecatedParams, *models.Principal) middleware.Responder

// Handle executing the request and returning a response
func (fn GetRolesForUserDeprecatedHandlerFunc) Handle(params GetRolesForUserDeprecatedParams, principal *models.Principal) middleware.Responder {
	return fn(params, principal)
}

// GetRolesForUserDeprecatedHandler interface for that can handle valid get roles for user deprecated params
type GetRolesForUserDeprecatedHandler interface {
	Handle(GetRolesForUserDeprecatedParams, *models.Principal) middleware.Responder
}

// NewGetRolesForUserDeprecated creates a new http.Handler for the get roles for user deprecated operation
func NewGetRolesForUserDeprecated(ctx *middleware.Context, handler GetRolesForUserDeprecatedHandler) *GetRolesForUserDeprecated {
	return &GetRolesForUserDeprecated{Context: ctx, Handler: handler}
}

/*
	GetRolesForUserDeprecated swagger:route GET /authz/users/{id}/roles authz getRolesForUserDeprecated

# Get roles assigned to a user

Retrieve the roles assigned to a specific user (`db` + `oidc`). Deprecated, will be removed when 1.29 is not supported anymore
*/
type GetRolesForUserDeprecated struct {
	Context *middleware.Context
	Handler GetRolesForUserDeprecatedHandler
}

func (o *GetRolesForUserDeprecated) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		*r = *rCtx
	}
	var Params = NewGetRolesForUserDeprecatedParams()
	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		*r = *aCtx
	}
	var principal *models.Principal
	if uprinc != nil {
		principal = uprinc.(*models.Principal) // this is really a models.Principal, I promise
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request
	o.Context.Respond(rw, r, route.Produces, route, res)

}
