//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// GetRolesForUserDeprecatedOKCode is the HTTP code returned for type GetRolesForUserDeprecatedOK
const GetRolesForUserDeprecatedOKCode int = 200

/*
GetRolesForUserDeprecatedOK Roles assigned to the user.

swagger:response getRolesForUserDeprecatedOK
*/
type GetRolesForUserDeprecatedOK struct {

	/*
	  In: Body
	*/
	Payload models.RolesListResponse `json:"body,omitempty"`
}

// NewGetRolesForUserDeprecatedOK creates GetRolesForUserDeprecatedOK with default headers values
func NewGetRolesForUserDeprecatedOK() *GetRolesForUserDeprecatedOK {

	return &GetRolesForUserDeprecatedOK{}
}

// WithPayload adds the payload to the get roles for user deprecated o k response
func (o *GetRolesForUserDeprecatedOK) WithPayload(payload models.RolesListResponse) *GetRolesForUserDeprecatedOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get roles for user deprecated o k response
func (o *GetRolesForUserDeprecatedOK) SetPayload(payload models.RolesListResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetRolesForUserDeprecatedOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.RolesListResponse{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// GetRolesForUserDeprecatedBadRequestCode is the HTTP code returned for type GetRolesForUserDeprecatedBadRequest
const GetRolesForUserDeprecatedBadRequestCode int = 400

/*
GetRolesForUserDeprecatedBadRequest Malformed request.

swagger:response getRolesForUserDeprecatedBadRequest
*/
type GetRolesForUserDeprecatedBadRequest struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewGetRolesForUserDeprecatedBadRequest creates GetRolesForUserDeprecatedBadRequest with default headers values
func NewGetRolesForUserDeprecatedBadRequest() *GetRolesForUserDeprecatedBadRequest {

	return &GetRolesForUserDeprecatedBadRequest{}
}

// WithPayload adds the payload to the get roles for user deprecated bad request response
func (o *GetRolesForUserDeprecatedBadRequest) WithPayload(payload *models.ErrorResponse) *GetRolesForUserDeprecatedBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get roles for user deprecated bad request response
func (o *GetRolesForUserDeprecatedBadRequest) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetRolesForUserDeprecatedBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetRolesForUserDeprecatedUnauthorizedCode is the HTTP code returned for type GetRolesForUserDeprecatedUnauthorized
const GetRolesForUserDeprecatedUnauthorizedCode int = 401

/*
GetRolesForUserDeprecatedUnauthorized Unauthorized or invalid credentials.

swagger:response getRolesForUserDeprecatedUnauthorized
*/
type GetRolesForUserDeprecatedUnauthorized struct {
}

// NewGetRolesForUserDeprecatedUnauthorized creates GetRolesForUserDeprecatedUnauthorized with default headers values
func NewGetRolesForUserDeprecatedUnauthorized() *GetRolesForUserDeprecatedUnauthorized {

	return &GetRolesForUserDeprecatedUnauthorized{}
}

// WriteResponse to the client
func (o *GetRolesForUserDeprecatedUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// GetRolesForUserDeprecatedForbiddenCode is the HTTP code returned for type GetRolesForUserDeprecatedForbidden
const GetRolesForUserDeprecatedForbiddenCode int = 403

/*
GetRolesForUserDeprecatedForbidden Forbidden

swagger:response getRolesForUserDeprecatedForbidden
*/
type GetRolesForUserDeprecatedForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewGetRolesForUserDeprecatedForbidden creates GetRolesForUserDeprecatedForbidden with default headers values
func NewGetRolesForUserDeprecatedForbidden() *GetRolesForUserDeprecatedForbidden {

	return &GetRolesForUserDeprecatedForbidden{}
}

// WithPayload adds the payload to the get roles for user deprecated forbidden response
func (o *GetRolesForUserDeprecatedForbidden) WithPayload(payload *models.ErrorResponse) *GetRolesForUserDeprecatedForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get roles for user deprecated forbidden response
func (o *GetRolesForUserDeprecatedForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetRolesForUserDeprecatedForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetRolesForUserDeprecatedNotFoundCode is the HTTP code returned for type GetRolesForUserDeprecatedNotFound
const GetRolesForUserDeprecatedNotFoundCode int = 404

/*
GetRolesForUserDeprecatedNotFound No roles found for specified user.

swagger:response getRolesForUserDeprecatedNotFound
*/
type GetRolesForUserDeprecatedNotFound struct {
}

// NewGetRolesForUserDeprecatedNotFound creates GetRolesForUserDeprecatedNotFound with default headers values
func NewGetRolesForUserDeprecatedNotFound() *GetRolesForUserDeprecatedNotFound {

	return &GetRolesForUserDeprecatedNotFound{}
}

// WriteResponse to the client
func (o *GetRolesForUserDeprecatedNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(404)
}

// GetRolesForUserDeprecatedUnprocessableEntityCode is the HTTP code returned for type GetRolesForUserDeprecatedUnprocessableEntity
const GetRolesForUserDeprecatedUnprocessableEntityCode int = 422

/*
GetRolesForUserDeprecatedUnprocessableEntity The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.

swagger:response getRolesForUserDeprecatedUnprocessableEntity
*/
type GetRolesForUserDeprecatedUnprocessableEntity struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewGetRolesForUserDeprecatedUnprocessableEntity creates GetRolesForUserDeprecatedUnprocessableEntity with default headers values
func NewGetRolesForUserDeprecatedUnprocessableEntity() *GetRolesForUserDeprecatedUnprocessableEntity {

	return &GetRolesForUserDeprecatedUnprocessableEntity{}
}

// WithPayload adds the payload to the get roles for user deprecated unprocessable entity response
func (o *GetRolesForUserDeprecatedUnprocessableEntity) WithPayload(payload *models.ErrorResponse) *GetRolesForUserDeprecatedUnprocessableEntity {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get roles for user deprecated unprocessable entity response
func (o *GetRolesForUserDeprecatedUnprocessableEntity) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetRolesForUserDeprecatedUnprocessableEntity) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(422)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetRolesForUserDeprecatedInternalServerErrorCode is the HTTP code returned for type GetRolesForUserDeprecatedInternalServerError
const GetRolesForUserDeprecatedInternalServerErrorCode int = 500

/*
GetRolesForUserDeprecatedInternalServerError An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.

swagger:response getRolesForUserDeprecatedInternalServerError
*/
type GetRolesForUserDeprecatedInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewGetRolesForUserDeprecatedInternalServerError creates GetRolesForUserDeprecatedInternalServerError with default headers values
func NewGetRolesForUserDeprecatedInternalServerError() *GetRolesForUserDeprecatedInternalServerError {

	return &GetRolesForUserDeprecatedInternalServerError{}
}

// WithPayload adds the payload to the get roles for user deprecated internal server error response
func (o *GetRolesForUserDeprecatedInternalServerError) WithPayload(payload *models.ErrorResponse) *GetRolesForUserDeprecatedInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get roles for user deprecated internal server error response
func (o *GetRolesForUserDeprecatedInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetRolesForUserDeprecatedInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
