//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"context"
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/weaviate/weaviate/entities/models"
)

// GetUsersForRoleHandlerFunc turns a function with the right signature into a get users for role handler
type GetUsersForRoleHandlerFunc func(GetUsersForRoleParams, *models.Principal) middleware.Responder

// Handle executing the request and returning a response
func (fn GetUsersForRoleHandlerFunc) Handle(params GetUsersForRoleParams, principal *models.Principal) middleware.Responder {
	return fn(params, principal)
}

// GetUsersForRoleHandler interface for that can handle valid get users for role params
type GetUsersForRoleHandler interface {
	Handle(GetUsersForRoleParams, *models.Principal) middleware.Responder
}

// NewGetUsersForRole creates a new http.Handler for the get users for role operation
func NewGetUsersForRole(ctx *middleware.Context, handler GetUsersForRoleHandler) *GetUsersForRole {
	return &GetUsersForRole{Context: ctx, Handler: handler}
}

/*
	GetUsersForRole swagger:route GET /authz/roles/{id}/user-assignments authz getUsersForRole

# Get users assigned to a role

Fetch a list of users which have the specified role.
*/
type GetUsersForRole struct {
	Context *middleware.Context
	Handler GetUsersForRoleHandler
}

func (o *GetUsersForRole) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		*r = *rCtx
	}
	var Params = NewGetUsersForRoleParams()
	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		*r = *aCtx
	}
	var principal *models.Principal
	if uprinc != nil {
		principal = uprinc.(*models.Principal) // this is really a models.Principal, I promise
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request
	o.Context.Respond(rw, r, route.Produces, route, res)

}

// GetUsersForRoleOKBodyItems0 get users for role o k body items0
//
// swagger:model GetUsersForRoleOKBodyItems0
type GetUsersForRoleOKBodyItems0 struct {

	// user Id
	UserID string `json:"userId,omitempty" yaml:"userId,omitempty"`

	// user type
	// Required: true
	UserType *models.UserTypeOutput `json:"userType" yaml:"userType"`
}

// Validate validates this get users for role o k body items0
func (o *GetUsersForRoleOKBodyItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateUserType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GetUsersForRoleOKBodyItems0) validateUserType(formats strfmt.Registry) error {

	if err := validate.Required("userType", "body", o.UserType); err != nil {
		return err
	}

	if err := validate.Required("userType", "body", o.UserType); err != nil {
		return err
	}

	if o.UserType != nil {
		if err := o.UserType.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("userType")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("userType")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this get users for role o k body items0 based on the context it is used
func (o *GetUsersForRoleOKBodyItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateUserType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GetUsersForRoleOKBodyItems0) contextValidateUserType(ctx context.Context, formats strfmt.Registry) error {

	if o.UserType != nil {
		if err := o.UserType.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("userType")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("userType")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *GetUsersForRoleOKBodyItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *GetUsersForRoleOKBodyItems0) UnmarshalBinary(b []byte) error {
	var res GetUsersForRoleOKBodyItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
