//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"net/http"

	"github.com/go-openapi/runtime/middleware"

	"github.com/weaviate/weaviate/entities/models"
)

// GetUsersForRoleDeprecatedHandlerFunc turns a function with the right signature into a get users for role deprecated handler
type GetUsersForRoleDeprecatedHandlerFunc func(GetUsersForRoleDeprecatedParams, *models.Principal) middleware.Responder

// Handle executing the request and returning a response
func (fn GetUsersForRoleDeprecatedHandlerFunc) Handle(params GetUsersForRoleDeprecatedParams, principal *models.Principal) middleware.Responder {
	return fn(params, principal)
}

// GetUsersForRoleDeprecatedHandler interface for that can handle valid get users for role deprecated params
type GetUsersForRoleDeprecatedHandler interface {
	Handle(GetUsersForRoleDeprecatedParams, *models.Principal) middleware.Responder
}

// NewGetUsersForRoleDeprecated creates a new http.Handler for the get users for role deprecated operation
func NewGetUsersForRoleDeprecated(ctx *middleware.Context, handler GetUsersForRoleDeprecatedHandler) *GetUsersForRoleDeprecated {
	return &GetUsersForRoleDeprecated{Context: ctx, Handler: handler}
}

/*
	GetUsersForRoleDeprecated swagger:route GET /authz/roles/{id}/users authz getUsersForRoleDeprecated

# Get users assigned to a role

Get all the users (`db` + `oidc`) who have been assigned a specific role. Deprecated, will be removed when v1.29 is not supported anymore.
*/
type GetUsersForRoleDeprecated struct {
	Context *middleware.Context
	Handler GetUsersForRoleDeprecatedHandler
}

func (o *GetUsersForRoleDeprecated) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		*r = *rCtx
	}
	var Params = NewGetUsersForRoleDeprecatedParams()
	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		*r = *aCtx
	}
	var principal *models.Principal
	if uprinc != nil {
		principal = uprinc.(*models.Principal) // this is really a models.Principal, I promise
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request
	o.Context.Respond(rw, r, route.Produces, route, res)

}
