//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// GetUsersForRoleDeprecatedOKCode is the HTTP code returned for type GetUsersForRoleDeprecatedOK
const GetUsersForRoleDeprecatedOKCode int = 200

/*
GetUsersForRoleDeprecatedOK Users assigned to this role.

swagger:response getUsersForRoleDeprecatedOK
*/
type GetUsersForRoleDeprecatedOK struct {

	/*
	  In: Body
	*/
	Payload []string `json:"body,omitempty"`
}

// NewGetUsersForRoleDeprecatedOK creates GetUsersForRoleDeprecatedOK with default headers values
func NewGetUsersForRoleDeprecatedOK() *GetUsersForRoleDeprecatedOK {

	return &GetUsersForRoleDeprecatedOK{}
}

// WithPayload adds the payload to the get users for role deprecated o k response
func (o *GetUsersForRoleDeprecatedOK) WithPayload(payload []string) *GetUsersForRoleDeprecatedOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get users for role deprecated o k response
func (o *GetUsersForRoleDeprecatedOK) SetPayload(payload []string) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetUsersForRoleDeprecatedOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = make([]string, 0, 50)
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// GetUsersForRoleDeprecatedBadRequestCode is the HTTP code returned for type GetUsersForRoleDeprecatedBadRequest
const GetUsersForRoleDeprecatedBadRequestCode int = 400

/*
GetUsersForRoleDeprecatedBadRequest Malformed request.

swagger:response getUsersForRoleDeprecatedBadRequest
*/
type GetUsersForRoleDeprecatedBadRequest struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewGetUsersForRoleDeprecatedBadRequest creates GetUsersForRoleDeprecatedBadRequest with default headers values
func NewGetUsersForRoleDeprecatedBadRequest() *GetUsersForRoleDeprecatedBadRequest {

	return &GetUsersForRoleDeprecatedBadRequest{}
}

// WithPayload adds the payload to the get users for role deprecated bad request response
func (o *GetUsersForRoleDeprecatedBadRequest) WithPayload(payload *models.ErrorResponse) *GetUsersForRoleDeprecatedBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get users for role deprecated bad request response
func (o *GetUsersForRoleDeprecatedBadRequest) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetUsersForRoleDeprecatedBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetUsersForRoleDeprecatedUnauthorizedCode is the HTTP code returned for type GetUsersForRoleDeprecatedUnauthorized
const GetUsersForRoleDeprecatedUnauthorizedCode int = 401

/*
GetUsersForRoleDeprecatedUnauthorized Unauthorized or invalid credentials.

swagger:response getUsersForRoleDeprecatedUnauthorized
*/
type GetUsersForRoleDeprecatedUnauthorized struct {
}

// NewGetUsersForRoleDeprecatedUnauthorized creates GetUsersForRoleDeprecatedUnauthorized with default headers values
func NewGetUsersForRoleDeprecatedUnauthorized() *GetUsersForRoleDeprecatedUnauthorized {

	return &GetUsersForRoleDeprecatedUnauthorized{}
}

// WriteResponse to the client
func (o *GetUsersForRoleDeprecatedUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// GetUsersForRoleDeprecatedForbiddenCode is the HTTP code returned for type GetUsersForRoleDeprecatedForbidden
const GetUsersForRoleDeprecatedForbiddenCode int = 403

/*
GetUsersForRoleDeprecatedForbidden Forbidden

swagger:response getUsersForRoleDeprecatedForbidden
*/
type GetUsersForRoleDeprecatedForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewGetUsersForRoleDeprecatedForbidden creates GetUsersForRoleDeprecatedForbidden with default headers values
func NewGetUsersForRoleDeprecatedForbidden() *GetUsersForRoleDeprecatedForbidden {

	return &GetUsersForRoleDeprecatedForbidden{}
}

// WithPayload adds the payload to the get users for role deprecated forbidden response
func (o *GetUsersForRoleDeprecatedForbidden) WithPayload(payload *models.ErrorResponse) *GetUsersForRoleDeprecatedForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get users for role deprecated forbidden response
func (o *GetUsersForRoleDeprecatedForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetUsersForRoleDeprecatedForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetUsersForRoleDeprecatedNotFoundCode is the HTTP code returned for type GetUsersForRoleDeprecatedNotFound
const GetUsersForRoleDeprecatedNotFoundCode int = 404

/*
GetUsersForRoleDeprecatedNotFound No role found.

swagger:response getUsersForRoleDeprecatedNotFound
*/
type GetUsersForRoleDeprecatedNotFound struct {
}

// NewGetUsersForRoleDeprecatedNotFound creates GetUsersForRoleDeprecatedNotFound with default headers values
func NewGetUsersForRoleDeprecatedNotFound() *GetUsersForRoleDeprecatedNotFound {

	return &GetUsersForRoleDeprecatedNotFound{}
}

// WriteResponse to the client
func (o *GetUsersForRoleDeprecatedNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(404)
}

// GetUsersForRoleDeprecatedInternalServerErrorCode is the HTTP code returned for type GetUsersForRoleDeprecatedInternalServerError
const GetUsersForRoleDeprecatedInternalServerErrorCode int = 500

/*
GetUsersForRoleDeprecatedInternalServerError An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.

swagger:response getUsersForRoleDeprecatedInternalServerError
*/
type GetUsersForRoleDeprecatedInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewGetUsersForRoleDeprecatedInternalServerError creates GetUsersForRoleDeprecatedInternalServerError with default headers values
func NewGetUsersForRoleDeprecatedInternalServerError() *GetUsersForRoleDeprecatedInternalServerError {

	return &GetUsersForRoleDeprecatedInternalServerError{}
}

// WithPayload adds the payload to the get users for role deprecated internal server error response
func (o *GetUsersForRoleDeprecatedInternalServerError) WithPayload(payload *models.ErrorResponse) *GetUsersForRoleDeprecatedInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get users for role deprecated internal server error response
func (o *GetUsersForRoleDeprecatedInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetUsersForRoleDeprecatedInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
