//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package objects

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"net/http"

	"github.com/go-openapi/runtime/middleware"

	"github.com/weaviate/weaviate/entities/models"
)

// ObjectsClassHeadHandlerFunc turns a function with the right signature into a objects class head handler
type ObjectsClassHeadHandlerFunc func(ObjectsClassHeadParams, *models.Principal) middleware.Responder

// Handle executing the request and returning a response
func (fn ObjectsClassHeadHandlerFunc) Handle(params ObjectsClassHeadParams, principal *models.Principal) middleware.Responder {
	return fn(params, principal)
}

// ObjectsClassHeadHandler interface for that can handle valid objects class head params
type ObjectsClassHeadHandler interface {
	Handle(ObjectsClassHeadParams, *models.Principal) middleware.Responder
}

// NewObjectsClassHead creates a new http.Handler for the objects class head operation
func NewObjectsClassHead(ctx *middleware.Context, handler ObjectsClassHeadHandler) *ObjectsClassHead {
	return &ObjectsClassHead{Context: ctx, Handler: handler}
}

/*
	ObjectsClassHead swagger:route HEAD /objects/{className}/{id} objects objectsClassHead

# Check if an object exists

Verifies the existence of a specific data object within a collection (class), identified by its collection name (`className`) and UUID (`id`), without returning the object itself.<br/><br/>This is faster than a GET request as it avoids retrieving and processing object data. Existence is confirmed by a 204 No Content status code, while non-existence results in a 404 Not Found.
*/
type ObjectsClassHead struct {
	Context *middleware.Context
	Handler ObjectsClassHeadHandler
}

func (o *ObjectsClassHead) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		*r = *rCtx
	}
	var Params = NewObjectsClassHeadParams()
	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		*r = *aCtx
	}
	var principal *models.Principal
	if uprinc != nil {
		principal = uprinc.(*models.Principal) // this is really a models.Principal, I promise
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request
	o.Context.Respond(rw, r, route.Produces, route, res)

}
