//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package replication

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// ApplyReplicationScalePlanOKCode is the HTTP code returned for type ApplyReplicationScalePlanOK
const ApplyReplicationScalePlanOKCode int = 200

/*
ApplyReplicationScalePlanOK List of replication shard copy operation IDs initiated for the scale operation

swagger:response applyReplicationScalePlanOK
*/
type ApplyReplicationScalePlanOK struct {

	/*
	  In: Body
	*/
	Payload *models.ReplicationScaleApplyResponse `json:"body,omitempty"`
}

// NewApplyReplicationScalePlanOK creates ApplyReplicationScalePlanOK with default headers values
func NewApplyReplicationScalePlanOK() *ApplyReplicationScalePlanOK {

	return &ApplyReplicationScalePlanOK{}
}

// WithPayload adds the payload to the apply replication scale plan o k response
func (o *ApplyReplicationScalePlanOK) WithPayload(payload *models.ReplicationScaleApplyResponse) *ApplyReplicationScalePlanOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the apply replication scale plan o k response
func (o *ApplyReplicationScalePlanOK) SetPayload(payload *models.ReplicationScaleApplyResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ApplyReplicationScalePlanOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ApplyReplicationScalePlanBadRequestCode is the HTTP code returned for type ApplyReplicationScalePlanBadRequest
const ApplyReplicationScalePlanBadRequestCode int = 400

/*
ApplyReplicationScalePlanBadRequest Bad request.

swagger:response applyReplicationScalePlanBadRequest
*/
type ApplyReplicationScalePlanBadRequest struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewApplyReplicationScalePlanBadRequest creates ApplyReplicationScalePlanBadRequest with default headers values
func NewApplyReplicationScalePlanBadRequest() *ApplyReplicationScalePlanBadRequest {

	return &ApplyReplicationScalePlanBadRequest{}
}

// WithPayload adds the payload to the apply replication scale plan bad request response
func (o *ApplyReplicationScalePlanBadRequest) WithPayload(payload *models.ErrorResponse) *ApplyReplicationScalePlanBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the apply replication scale plan bad request response
func (o *ApplyReplicationScalePlanBadRequest) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ApplyReplicationScalePlanBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ApplyReplicationScalePlanUnauthorizedCode is the HTTP code returned for type ApplyReplicationScalePlanUnauthorized
const ApplyReplicationScalePlanUnauthorizedCode int = 401

/*
ApplyReplicationScalePlanUnauthorized Unauthorized or invalid credentials.

swagger:response applyReplicationScalePlanUnauthorized
*/
type ApplyReplicationScalePlanUnauthorized struct {
}

// NewApplyReplicationScalePlanUnauthorized creates ApplyReplicationScalePlanUnauthorized with default headers values
func NewApplyReplicationScalePlanUnauthorized() *ApplyReplicationScalePlanUnauthorized {

	return &ApplyReplicationScalePlanUnauthorized{}
}

// WriteResponse to the client
func (o *ApplyReplicationScalePlanUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// ApplyReplicationScalePlanForbiddenCode is the HTTP code returned for type ApplyReplicationScalePlanForbidden
const ApplyReplicationScalePlanForbiddenCode int = 403

/*
ApplyReplicationScalePlanForbidden Forbidden

swagger:response applyReplicationScalePlanForbidden
*/
type ApplyReplicationScalePlanForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewApplyReplicationScalePlanForbidden creates ApplyReplicationScalePlanForbidden with default headers values
func NewApplyReplicationScalePlanForbidden() *ApplyReplicationScalePlanForbidden {

	return &ApplyReplicationScalePlanForbidden{}
}

// WithPayload adds the payload to the apply replication scale plan forbidden response
func (o *ApplyReplicationScalePlanForbidden) WithPayload(payload *models.ErrorResponse) *ApplyReplicationScalePlanForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the apply replication scale plan forbidden response
func (o *ApplyReplicationScalePlanForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ApplyReplicationScalePlanForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ApplyReplicationScalePlanNotFoundCode is the HTTP code returned for type ApplyReplicationScalePlanNotFound
const ApplyReplicationScalePlanNotFoundCode int = 404

/*
ApplyReplicationScalePlanNotFound Collection not found.

swagger:response applyReplicationScalePlanNotFound
*/
type ApplyReplicationScalePlanNotFound struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewApplyReplicationScalePlanNotFound creates ApplyReplicationScalePlanNotFound with default headers values
func NewApplyReplicationScalePlanNotFound() *ApplyReplicationScalePlanNotFound {

	return &ApplyReplicationScalePlanNotFound{}
}

// WithPayload adds the payload to the apply replication scale plan not found response
func (o *ApplyReplicationScalePlanNotFound) WithPayload(payload *models.ErrorResponse) *ApplyReplicationScalePlanNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the apply replication scale plan not found response
func (o *ApplyReplicationScalePlanNotFound) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ApplyReplicationScalePlanNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ApplyReplicationScalePlanInternalServerErrorCode is the HTTP code returned for type ApplyReplicationScalePlanInternalServerError
const ApplyReplicationScalePlanInternalServerErrorCode int = 500

/*
ApplyReplicationScalePlanInternalServerError An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.

swagger:response applyReplicationScalePlanInternalServerError
*/
type ApplyReplicationScalePlanInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewApplyReplicationScalePlanInternalServerError creates ApplyReplicationScalePlanInternalServerError with default headers values
func NewApplyReplicationScalePlanInternalServerError() *ApplyReplicationScalePlanInternalServerError {

	return &ApplyReplicationScalePlanInternalServerError{}
}

// WithPayload adds the payload to the apply replication scale plan internal server error response
func (o *ApplyReplicationScalePlanInternalServerError) WithPayload(payload *models.ErrorResponse) *ApplyReplicationScalePlanInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the apply replication scale plan internal server error response
func (o *ApplyReplicationScalePlanInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ApplyReplicationScalePlanInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ApplyReplicationScalePlanNotImplementedCode is the HTTP code returned for type ApplyReplicationScalePlanNotImplemented
const ApplyReplicationScalePlanNotImplementedCode int = 501

/*
ApplyReplicationScalePlanNotImplemented Replica movement operations are disabled.

swagger:response applyReplicationScalePlanNotImplemented
*/
type ApplyReplicationScalePlanNotImplemented struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewApplyReplicationScalePlanNotImplemented creates ApplyReplicationScalePlanNotImplemented with default headers values
func NewApplyReplicationScalePlanNotImplemented() *ApplyReplicationScalePlanNotImplemented {

	return &ApplyReplicationScalePlanNotImplemented{}
}

// WithPayload adds the payload to the apply replication scale plan not implemented response
func (o *ApplyReplicationScalePlanNotImplemented) WithPayload(payload *models.ErrorResponse) *ApplyReplicationScalePlanNotImplemented {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the apply replication scale plan not implemented response
func (o *ApplyReplicationScalePlanNotImplemented) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ApplyReplicationScalePlanNotImplemented) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(501)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
