//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package replication

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// CancelReplicationNoContentCode is the HTTP code returned for type CancelReplicationNoContent
const CancelReplicationNoContentCode int = 204

/*
CancelReplicationNoContent Successfully cancelled.

swagger:response cancelReplicationNoContent
*/
type CancelReplicationNoContent struct {
}

// NewCancelReplicationNoContent creates CancelReplicationNoContent with default headers values
func NewCancelReplicationNoContent() *CancelReplicationNoContent {

	return &CancelReplicationNoContent{}
}

// WriteResponse to the client
func (o *CancelReplicationNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// CancelReplicationUnauthorizedCode is the HTTP code returned for type CancelReplicationUnauthorized
const CancelReplicationUnauthorizedCode int = 401

/*
CancelReplicationUnauthorized Unauthorized or invalid credentials.

swagger:response cancelReplicationUnauthorized
*/
type CancelReplicationUnauthorized struct {
}

// NewCancelReplicationUnauthorized creates CancelReplicationUnauthorized with default headers values
func NewCancelReplicationUnauthorized() *CancelReplicationUnauthorized {

	return &CancelReplicationUnauthorized{}
}

// WriteResponse to the client
func (o *CancelReplicationUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// CancelReplicationForbiddenCode is the HTTP code returned for type CancelReplicationForbidden
const CancelReplicationForbiddenCode int = 403

/*
CancelReplicationForbidden Forbidden

swagger:response cancelReplicationForbidden
*/
type CancelReplicationForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewCancelReplicationForbidden creates CancelReplicationForbidden with default headers values
func NewCancelReplicationForbidden() *CancelReplicationForbidden {

	return &CancelReplicationForbidden{}
}

// WithPayload adds the payload to the cancel replication forbidden response
func (o *CancelReplicationForbidden) WithPayload(payload *models.ErrorResponse) *CancelReplicationForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the cancel replication forbidden response
func (o *CancelReplicationForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CancelReplicationForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CancelReplicationNotFoundCode is the HTTP code returned for type CancelReplicationNotFound
const CancelReplicationNotFoundCode int = 404

/*
CancelReplicationNotFound Shard replica operation not found.

swagger:response cancelReplicationNotFound
*/
type CancelReplicationNotFound struct {
}

// NewCancelReplicationNotFound creates CancelReplicationNotFound with default headers values
func NewCancelReplicationNotFound() *CancelReplicationNotFound {

	return &CancelReplicationNotFound{}
}

// WriteResponse to the client
func (o *CancelReplicationNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(404)
}

// CancelReplicationConflictCode is the HTTP code returned for type CancelReplicationConflict
const CancelReplicationConflictCode int = 409

/*
CancelReplicationConflict The operation is not in a cancellable state, e.g. it is READY or is a MOVE op in the DEHYDRATING state.

swagger:response cancelReplicationConflict
*/
type CancelReplicationConflict struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewCancelReplicationConflict creates CancelReplicationConflict with default headers values
func NewCancelReplicationConflict() *CancelReplicationConflict {

	return &CancelReplicationConflict{}
}

// WithPayload adds the payload to the cancel replication conflict response
func (o *CancelReplicationConflict) WithPayload(payload *models.ErrorResponse) *CancelReplicationConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the cancel replication conflict response
func (o *CancelReplicationConflict) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CancelReplicationConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CancelReplicationUnprocessableEntityCode is the HTTP code returned for type CancelReplicationUnprocessableEntity
const CancelReplicationUnprocessableEntityCode int = 422

/*
CancelReplicationUnprocessableEntity The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.

swagger:response cancelReplicationUnprocessableEntity
*/
type CancelReplicationUnprocessableEntity struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewCancelReplicationUnprocessableEntity creates CancelReplicationUnprocessableEntity with default headers values
func NewCancelReplicationUnprocessableEntity() *CancelReplicationUnprocessableEntity {

	return &CancelReplicationUnprocessableEntity{}
}

// WithPayload adds the payload to the cancel replication unprocessable entity response
func (o *CancelReplicationUnprocessableEntity) WithPayload(payload *models.ErrorResponse) *CancelReplicationUnprocessableEntity {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the cancel replication unprocessable entity response
func (o *CancelReplicationUnprocessableEntity) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CancelReplicationUnprocessableEntity) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(422)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CancelReplicationInternalServerErrorCode is the HTTP code returned for type CancelReplicationInternalServerError
const CancelReplicationInternalServerErrorCode int = 500

/*
CancelReplicationInternalServerError An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.

swagger:response cancelReplicationInternalServerError
*/
type CancelReplicationInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewCancelReplicationInternalServerError creates CancelReplicationInternalServerError with default headers values
func NewCancelReplicationInternalServerError() *CancelReplicationInternalServerError {

	return &CancelReplicationInternalServerError{}
}

// WithPayload adds the payload to the cancel replication internal server error response
func (o *CancelReplicationInternalServerError) WithPayload(payload *models.ErrorResponse) *CancelReplicationInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the cancel replication internal server error response
func (o *CancelReplicationInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CancelReplicationInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CancelReplicationNotImplementedCode is the HTTP code returned for type CancelReplicationNotImplemented
const CancelReplicationNotImplementedCode int = 501

/*
CancelReplicationNotImplemented Replica movement operations are disabled.

swagger:response cancelReplicationNotImplemented
*/
type CancelReplicationNotImplemented struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewCancelReplicationNotImplemented creates CancelReplicationNotImplemented with default headers values
func NewCancelReplicationNotImplemented() *CancelReplicationNotImplemented {

	return &CancelReplicationNotImplemented{}
}

// WithPayload adds the payload to the cancel replication not implemented response
func (o *CancelReplicationNotImplemented) WithPayload(payload *models.ErrorResponse) *CancelReplicationNotImplemented {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the cancel replication not implemented response
func (o *CancelReplicationNotImplemented) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CancelReplicationNotImplemented) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(501)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
