//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package replication

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// GetCollectionShardingStateOKCode is the HTTP code returned for type GetCollectionShardingStateOK
const GetCollectionShardingStateOKCode int = 200

/*
GetCollectionShardingStateOK Successfully retrieved sharding state.

swagger:response getCollectionShardingStateOK
*/
type GetCollectionShardingStateOK struct {

	/*
	  In: Body
	*/
	Payload *models.ReplicationShardingStateResponse `json:"body,omitempty"`
}

// NewGetCollectionShardingStateOK creates GetCollectionShardingStateOK with default headers values
func NewGetCollectionShardingStateOK() *GetCollectionShardingStateOK {

	return &GetCollectionShardingStateOK{}
}

// WithPayload adds the payload to the get collection sharding state o k response
func (o *GetCollectionShardingStateOK) WithPayload(payload *models.ReplicationShardingStateResponse) *GetCollectionShardingStateOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get collection sharding state o k response
func (o *GetCollectionShardingStateOK) SetPayload(payload *models.ReplicationShardingStateResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetCollectionShardingStateOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetCollectionShardingStateBadRequestCode is the HTTP code returned for type GetCollectionShardingStateBadRequest
const GetCollectionShardingStateBadRequestCode int = 400

/*
GetCollectionShardingStateBadRequest Bad request.

swagger:response getCollectionShardingStateBadRequest
*/
type GetCollectionShardingStateBadRequest struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewGetCollectionShardingStateBadRequest creates GetCollectionShardingStateBadRequest with default headers values
func NewGetCollectionShardingStateBadRequest() *GetCollectionShardingStateBadRequest {

	return &GetCollectionShardingStateBadRequest{}
}

// WithPayload adds the payload to the get collection sharding state bad request response
func (o *GetCollectionShardingStateBadRequest) WithPayload(payload *models.ErrorResponse) *GetCollectionShardingStateBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get collection sharding state bad request response
func (o *GetCollectionShardingStateBadRequest) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetCollectionShardingStateBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetCollectionShardingStateUnauthorizedCode is the HTTP code returned for type GetCollectionShardingStateUnauthorized
const GetCollectionShardingStateUnauthorizedCode int = 401

/*
GetCollectionShardingStateUnauthorized Unauthorized or invalid credentials.

swagger:response getCollectionShardingStateUnauthorized
*/
type GetCollectionShardingStateUnauthorized struct {
}

// NewGetCollectionShardingStateUnauthorized creates GetCollectionShardingStateUnauthorized with default headers values
func NewGetCollectionShardingStateUnauthorized() *GetCollectionShardingStateUnauthorized {

	return &GetCollectionShardingStateUnauthorized{}
}

// WriteResponse to the client
func (o *GetCollectionShardingStateUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// GetCollectionShardingStateForbiddenCode is the HTTP code returned for type GetCollectionShardingStateForbidden
const GetCollectionShardingStateForbiddenCode int = 403

/*
GetCollectionShardingStateForbidden Forbidden

swagger:response getCollectionShardingStateForbidden
*/
type GetCollectionShardingStateForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewGetCollectionShardingStateForbidden creates GetCollectionShardingStateForbidden with default headers values
func NewGetCollectionShardingStateForbidden() *GetCollectionShardingStateForbidden {

	return &GetCollectionShardingStateForbidden{}
}

// WithPayload adds the payload to the get collection sharding state forbidden response
func (o *GetCollectionShardingStateForbidden) WithPayload(payload *models.ErrorResponse) *GetCollectionShardingStateForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get collection sharding state forbidden response
func (o *GetCollectionShardingStateForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetCollectionShardingStateForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetCollectionShardingStateNotFoundCode is the HTTP code returned for type GetCollectionShardingStateNotFound
const GetCollectionShardingStateNotFoundCode int = 404

/*
GetCollectionShardingStateNotFound Collection or shard not found.

swagger:response getCollectionShardingStateNotFound
*/
type GetCollectionShardingStateNotFound struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewGetCollectionShardingStateNotFound creates GetCollectionShardingStateNotFound with default headers values
func NewGetCollectionShardingStateNotFound() *GetCollectionShardingStateNotFound {

	return &GetCollectionShardingStateNotFound{}
}

// WithPayload adds the payload to the get collection sharding state not found response
func (o *GetCollectionShardingStateNotFound) WithPayload(payload *models.ErrorResponse) *GetCollectionShardingStateNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get collection sharding state not found response
func (o *GetCollectionShardingStateNotFound) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetCollectionShardingStateNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetCollectionShardingStateInternalServerErrorCode is the HTTP code returned for type GetCollectionShardingStateInternalServerError
const GetCollectionShardingStateInternalServerErrorCode int = 500

/*
GetCollectionShardingStateInternalServerError An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.

swagger:response getCollectionShardingStateInternalServerError
*/
type GetCollectionShardingStateInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewGetCollectionShardingStateInternalServerError creates GetCollectionShardingStateInternalServerError with default headers values
func NewGetCollectionShardingStateInternalServerError() *GetCollectionShardingStateInternalServerError {

	return &GetCollectionShardingStateInternalServerError{}
}

// WithPayload adds the payload to the get collection sharding state internal server error response
func (o *GetCollectionShardingStateInternalServerError) WithPayload(payload *models.ErrorResponse) *GetCollectionShardingStateInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get collection sharding state internal server error response
func (o *GetCollectionShardingStateInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetCollectionShardingStateInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetCollectionShardingStateNotImplementedCode is the HTTP code returned for type GetCollectionShardingStateNotImplemented
const GetCollectionShardingStateNotImplementedCode int = 501

/*
GetCollectionShardingStateNotImplemented Replica movement operations are disabled.

swagger:response getCollectionShardingStateNotImplemented
*/
type GetCollectionShardingStateNotImplemented struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewGetCollectionShardingStateNotImplemented creates GetCollectionShardingStateNotImplemented with default headers values
func NewGetCollectionShardingStateNotImplemented() *GetCollectionShardingStateNotImplemented {

	return &GetCollectionShardingStateNotImplemented{}
}

// WithPayload adds the payload to the get collection sharding state not implemented response
func (o *GetCollectionShardingStateNotImplemented) WithPayload(payload *models.ErrorResponse) *GetCollectionShardingStateNotImplemented {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get collection sharding state not implemented response
func (o *GetCollectionShardingStateNotImplemented) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetCollectionShardingStateNotImplemented) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(501)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
