//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package replication

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"net/http"

	"github.com/go-openapi/runtime/middleware"

	"github.com/weaviate/weaviate/entities/models"
)

// ListReplicationHandlerFunc turns a function with the right signature into a list replication handler
type ListReplicationHandlerFunc func(ListReplicationParams, *models.Principal) middleware.Responder

// Handle executing the request and returning a response
func (fn ListReplicationHandlerFunc) Handle(params ListReplicationParams, principal *models.Principal) middleware.Responder {
	return fn(params, principal)
}

// ListReplicationHandler interface for that can handle valid list replication params
type ListReplicationHandler interface {
	Handle(ListReplicationParams, *models.Principal) middleware.Responder
}

// NewListReplication creates a new http.Handler for the list replication operation
func NewListReplication(ctx *middleware.Context, handler ListReplicationHandler) *ListReplication {
	return &ListReplication{Context: ctx, Handler: handler}
}

/*
	ListReplication swagger:route GET /replication/replicate/list replication listReplication

# List replication operations

Retrieves a list of currently registered replication operations, optionally filtered by collection, shard, or node ID.
*/
type ListReplication struct {
	Context *middleware.Context
	Handler ListReplicationHandler
}

func (o *ListReplication) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		*r = *rCtx
	}
	var Params = NewListReplicationParams()
	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		*r = *aCtx
	}
	var principal *models.Principal
	if uprinc != nil {
		principal = uprinc.(*models.Principal) // this is really a models.Principal, I promise
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request
	o.Context.Respond(rw, r, route.Produces, route, res)

}
