//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package replication

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// ListReplicationOKCode is the HTTP code returned for type ListReplicationOK
const ListReplicationOKCode int = 200

/*
ListReplicationOK The details of the replication operations.

swagger:response listReplicationOK
*/
type ListReplicationOK struct {

	/*
	  In: Body
	*/
	Payload []*models.ReplicationReplicateDetailsReplicaResponse `json:"body,omitempty"`
}

// NewListReplicationOK creates ListReplicationOK with default headers values
func NewListReplicationOK() *ListReplicationOK {

	return &ListReplicationOK{}
}

// WithPayload adds the payload to the list replication o k response
func (o *ListReplicationOK) WithPayload(payload []*models.ReplicationReplicateDetailsReplicaResponse) *ListReplicationOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the list replication o k response
func (o *ListReplicationOK) SetPayload(payload []*models.ReplicationReplicateDetailsReplicaResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ListReplicationOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = make([]*models.ReplicationReplicateDetailsReplicaResponse, 0, 50)
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ListReplicationBadRequestCode is the HTTP code returned for type ListReplicationBadRequest
const ListReplicationBadRequestCode int = 400

/*
ListReplicationBadRequest Bad request.

swagger:response listReplicationBadRequest
*/
type ListReplicationBadRequest struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewListReplicationBadRequest creates ListReplicationBadRequest with default headers values
func NewListReplicationBadRequest() *ListReplicationBadRequest {

	return &ListReplicationBadRequest{}
}

// WithPayload adds the payload to the list replication bad request response
func (o *ListReplicationBadRequest) WithPayload(payload *models.ErrorResponse) *ListReplicationBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the list replication bad request response
func (o *ListReplicationBadRequest) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ListReplicationBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ListReplicationUnauthorizedCode is the HTTP code returned for type ListReplicationUnauthorized
const ListReplicationUnauthorizedCode int = 401

/*
ListReplicationUnauthorized Unauthorized or invalid credentials.

swagger:response listReplicationUnauthorized
*/
type ListReplicationUnauthorized struct {
}

// NewListReplicationUnauthorized creates ListReplicationUnauthorized with default headers values
func NewListReplicationUnauthorized() *ListReplicationUnauthorized {

	return &ListReplicationUnauthorized{}
}

// WriteResponse to the client
func (o *ListReplicationUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// ListReplicationForbiddenCode is the HTTP code returned for type ListReplicationForbidden
const ListReplicationForbiddenCode int = 403

/*
ListReplicationForbidden Forbidden

swagger:response listReplicationForbidden
*/
type ListReplicationForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewListReplicationForbidden creates ListReplicationForbidden with default headers values
func NewListReplicationForbidden() *ListReplicationForbidden {

	return &ListReplicationForbidden{}
}

// WithPayload adds the payload to the list replication forbidden response
func (o *ListReplicationForbidden) WithPayload(payload *models.ErrorResponse) *ListReplicationForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the list replication forbidden response
func (o *ListReplicationForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ListReplicationForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ListReplicationInternalServerErrorCode is the HTTP code returned for type ListReplicationInternalServerError
const ListReplicationInternalServerErrorCode int = 500

/*
ListReplicationInternalServerError An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.

swagger:response listReplicationInternalServerError
*/
type ListReplicationInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewListReplicationInternalServerError creates ListReplicationInternalServerError with default headers values
func NewListReplicationInternalServerError() *ListReplicationInternalServerError {

	return &ListReplicationInternalServerError{}
}

// WithPayload adds the payload to the list replication internal server error response
func (o *ListReplicationInternalServerError) WithPayload(payload *models.ErrorResponse) *ListReplicationInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the list replication internal server error response
func (o *ListReplicationInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ListReplicationInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ListReplicationNotImplementedCode is the HTTP code returned for type ListReplicationNotImplemented
const ListReplicationNotImplementedCode int = 501

/*
ListReplicationNotImplemented Replica movement operations are disabled.

swagger:response listReplicationNotImplemented
*/
type ListReplicationNotImplemented struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewListReplicationNotImplemented creates ListReplicationNotImplemented with default headers values
func NewListReplicationNotImplemented() *ListReplicationNotImplemented {

	return &ListReplicationNotImplemented{}
}

// WithPayload adds the payload to the list replication not implemented response
func (o *ListReplicationNotImplemented) WithPayload(payload *models.ErrorResponse) *ListReplicationNotImplemented {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the list replication not implemented response
func (o *ListReplicationNotImplemented) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ListReplicationNotImplemented) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(501)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
