//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package replication

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"net/http"

	"github.com/go-openapi/runtime/middleware"

	"github.com/weaviate/weaviate/entities/models"
)

// ReplicateHandlerFunc turns a function with the right signature into a replicate handler
type ReplicateHandlerFunc func(ReplicateParams, *models.Principal) middleware.Responder

// Handle executing the request and returning a response
func (fn ReplicateHandlerFunc) Handle(params ReplicateParams, principal *models.Principal) middleware.Responder {
	return fn(params, principal)
}

// ReplicateHandler interface for that can handle valid replicate params
type ReplicateHandler interface {
	Handle(ReplicateParams, *models.Principal) middleware.Responder
}

// NewReplicate creates a new http.Handler for the replicate operation
func NewReplicate(ctx *middleware.Context, handler ReplicateHandler) *Replicate {
	return &Replicate{Context: ctx, Handler: handler}
}

/*
	Replicate swagger:route POST /replication/replicate replication replicate

# Initiate a replica movement

Begins an asynchronous operation to move or copy a specific shard replica from its current node to a designated target node. The operation involves copying data, synchronizing, and potentially decommissioning the source replica.
*/
type Replicate struct {
	Context *middleware.Context
	Handler ReplicateHandler
}

func (o *Replicate) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		*r = *rCtx
	}
	var Params = NewReplicateParams()
	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		*r = *aCtx
	}
	var principal *models.Principal
	if uprinc != nil {
		principal = uprinc.(*models.Principal) // this is really a models.Principal, I promise
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request
	o.Context.Respond(rw, r, route.Produces, route, res)

}
